/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.remote.command;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;

public class TaskExecuteResponseCommand
implements Serializable {
    private int taskInstanceId;
    private int processInstanceId;
    private int status;
    private Date startTime;
    private String host;
    private String logPath;
    private String executePath;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date endTime;
    private int processId;
    private String appIds;
    private String varPool;

    public TaskExecuteResponseCommand() {
    }

    public TaskExecuteResponseCommand(int taskInstanceId, int processInstanceId) {
        this.taskInstanceId = taskInstanceId;
        this.processInstanceId = processInstanceId;
    }

    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    public String getVarPool() {
        return this.varPool;
    }

    public int getTaskInstanceId() {
        return this.taskInstanceId;
    }

    public void setTaskInstanceId(int taskInstanceId) {
        this.taskInstanceId = taskInstanceId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public String getAppIds() {
        return this.appIds;
    }

    public void setAppIds(String appIds) {
        this.appIds = appIds;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public String getExecutePath() {
        return this.executePath;
    }

    public void setExecutePath(String executePath) {
        this.executePath = executePath;
    }

    public Command convert2Command() {
        Command command = new Command();
        command.setType(CommandType.TASK_EXECUTE_RESPONSE);
        command.setGenCommandTimeMillis(System.currentTimeMillis());
        byte[] body = JSONUtils.toJsonByteArray((Object)this);
        command.setBody(body);
        return command;
    }

    public String toString() {
        return "TaskExecuteResponseCommand{taskInstanceId=" + this.taskInstanceId + ", processInstanceId=" + this.processInstanceId + ", status=" + this.status + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", host=" + this.host + ", logPath=" + this.logPath + ", executePath=" + this.executePath + ", processId=" + this.processId + ", appIds='" + this.appIds + '\'' + ", varPool=" + this.varPool + '}';
    }

    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }
}

