/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.shell;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.shell.ShellParameters;
import org.apache.dolphinscheduler.plugin.task.util.OSUtils;
import org.apache.dolphinscheduler.spi.task.AbstractParameters;
import org.apache.dolphinscheduler.spi.task.paramparser.ParamUtils;
import org.apache.dolphinscheduler.spi.task.paramparser.ParameterUtils;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;

public class ShellTask
extends AbstractTaskExecutor {
    private ShellParameters shellParameters;
    private ShellCommandExecutor shellCommandExecutor;
    private TaskRequest taskExecutionContext;

    public ShellTask(TaskRequest taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
        this.shellCommandExecutor = new ShellCommandExecutor(arg_0 -> ((ShellTask)this).logHandle(arg_0), taskExecutionContext, this.logger);
    }

    public void init() {
        this.logger.info("shell task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.shellParameters = (ShellParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), ShellParameters.class));
        if (!this.shellParameters.checkParameters()) {
            throw new RuntimeException("shell task params is not valid");
        }
    }

    public void handle() throws Exception {
        try {
            String command = this.buildCommand();
            TaskResponse commandExecuteResult = this.shellCommandExecutor.run(command);
            this.setExitStatusCode(commandExecuteResult.getExitStatusCode());
            this.setAppIds(commandExecuteResult.getAppIds());
            this.setProcessId(commandExecuteResult.getProcessId());
            this.shellParameters.dealOutParam(this.shellCommandExecutor.getVarPool());
        }
        catch (Exception e) {
            this.logger.error("shell task error", (Throwable)e);
            this.setExitStatusCode(-1);
            throw e;
        }
    }

    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.shellCommandExecutor.cancelApplication();
    }

    private String buildCommand() throws Exception {
        String fileName = String.format("%s/%s_node.%s", this.taskExecutionContext.getExecutePath(), this.taskExecutionContext.getTaskAppId(), OSUtils.isWindows() ? "bat" : "sh");
        Path path = new File(fileName).toPath();
        if (Files.exists(path, new LinkOption[0])) {
            return fileName;
        }
        String script = this.shellParameters.getRawScript().replaceAll("\\r\\n", "\n");
        script = this.parseScript(script);
        this.shellParameters.setRawScript(script);
        this.logger.info("raw script : {}", (Object)this.shellParameters.getRawScript());
        this.logger.info("task execute path : {}", (Object)this.taskExecutionContext.getExecutePath());
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        if (OSUtils.isWindows()) {
            Files.createFile(path, new FileAttribute[0]);
        } else {
            Files.createFile(path, attr);
        }
        Files.write(path, this.shellParameters.getRawScript().getBytes(), StandardOpenOption.APPEND);
        return fileName;
    }

    public AbstractParameters getParameters() {
        return this.shellParameters;
    }

    private String parseScript(String script) {
        HashMap paramsMap = ParamUtils.convert((TaskRequest)this.taskExecutionContext, (AbstractParameters)this.getParameters());
        if (MapUtils.isEmpty((Map)paramsMap)) {
            paramsMap = new HashMap();
        }
        if (MapUtils.isNotEmpty((Map)this.taskExecutionContext.getParamsMap())) {
            paramsMap.putAll(this.taskExecutionContext.getParamsMap());
        }
        return ParameterUtils.convertParameterPlaceholders((String)script, (Map)ParamUtils.convert(paramsMap));
    }
}

