/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final Properties properties = new Properties();

    private PropertyUtils() {
        throw new UnsupportedOperationException("Construct PropertyUtils");
    }

    public static synchronized void loadPropertyFile(String ... propertyFiles) {
        for (String fileName : propertyFiles) {
            try (InputStream fis = PropertyUtils.class.getResourceAsStream(fileName);){
                properties.load(fis);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                System.exit(1);
            }
        }
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = String.valueOf(k);
            logger.info("Overriding property from system property: {}", (Object)key);
            PropertyUtils.setValue(key, String.valueOf(v));
        }));
    }

    public static String getString(String key) {
        return properties.getProperty(key.trim());
    }

    public static String getUpperCaseString(String key) {
        String val = PropertyUtils.getString(key);
        return StringUtils.isEmpty(val) ? val : val.toUpperCase();
    }

    public static String getString(String key, String defaultVal) {
        String val = PropertyUtils.getString(key);
        return StringUtils.isEmpty(val) ? defaultVal : val;
    }

    public static int getInt(String key) {
        return PropertyUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        String value = PropertyUtils.getString(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean getBoolean(String key) {
        return PropertyUtils.getBoolean(key, false);
    }

    public static Boolean getBoolean(String key, boolean defaultValue) {
        String value = PropertyUtils.getString(key);
        return StringUtils.isEmpty(value) ? defaultValue : Boolean.parseBoolean(value);
    }

    public static long getLong(String key, long defaultValue) {
        String value = PropertyUtils.getString(key);
        if (StringUtils.isEmpty(value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static long getLong(String key) {
        return PropertyUtils.getLong(key, -1L);
    }

    public static void setValue(String key, String value) {
        properties.setProperty(key, value);
    }

    public static String dumpProperties() {
        return properties.toString();
    }

    static {
        PropertyUtils.loadPropertyFile("/common.properties");
    }
}

