/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.params.input;

import java.util.ArrayList;
import java.util.List;
import org.apache.dolphinscheduler.spi.params.base.FormType;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.input.InputParamProps;

public class InputParam
extends PluginParams {
    private InputParamProps props;

    private InputParam(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder(String name, String title) {
        return new Builder(name, title);
    }

    @Override
    public InputParamProps getProps() {
        return this.props;
    }

    public static class Builder
    extends PluginParams.Builder {
        private InputParamProps props;

        public Builder(String name, String title) {
            super(name, FormType.INPUT, title);
        }

        public Builder setProps(InputParamProps props) {
            this.props = props;
            return this;
        }

        public Builder setPlaceholder(String placeholder) {
            if (this.props == null) {
                this.setProps(new InputParamProps());
            }
            this.props.setPlaceholder(placeholder);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setInfo(String info) {
            this.info = info;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public Builder setValidateList(List<Validate> validateList) {
            this.validateList = validateList;
            return this;
        }

        public Builder addValidate(Validate validate) {
            if (this.validateList == null) {
                this.validateList = new ArrayList();
            }
            this.validateList.add(validate);
            return this;
        }

        public Builder setHidden(Boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder setDisplay(Boolean display) {
            this.display = display;
            return this;
        }

        @Override
        public InputParam build() {
            return new InputParam(this);
        }
    }
}

