/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.DependResult;
import org.apache.dolphinscheduler.common.enums.DependentRelation;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.model.DateInterval;
import org.apache.dolphinscheduler.common.model.DependentItem;
import org.apache.dolphinscheduler.common.utils.DependentUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentExecute {
    private final ProcessService processService = (ProcessService)SpringApplicationContext.getBean(ProcessService.class);
    private List<DependentItem> dependItemList;
    private DependentRelation relation;
    private DependResult modelDependResult = DependResult.WAITING;
    private Map<String, DependResult> dependResultMap = new HashMap<String, DependResult>();
    protected final Logger logger = LoggerFactory.getLogger((String)String.format("TaskLogLogger-%s", this.getClass()));

    public DependentExecute(List<DependentItem> itemList, DependentRelation relation) {
        this.dependItemList = itemList;
        this.relation = relation;
    }

    private DependResult getDependentResultForItem(DependentItem dependentItem, Date currentTime) {
        List dateIntervals = DependentUtils.getDateIntervalList((Date)currentTime, (String)dependentItem.getDateValue());
        return this.calculateResultForTasks(dependentItem, dateIntervals);
    }

    private DependResult calculateResultForTasks(DependentItem dependentItem, List<DateInterval> dateIntervals) {
        DependResult result = DependResult.FAILED;
        for (DateInterval dateInterval : dateIntervals) {
            ProcessInstance processInstance = this.findLastProcessInterval(dependentItem.getDefinitionCode(), dateInterval);
            if (processInstance == null) {
                this.logger.info("Cannot find dependent processInstance, waiting for workflow to run, processDefiniteCode:{}, taskCode:{}", (Object)dependentItem.getDefinitionCode(), (Object)dependentItem.getDepTaskCode());
                return DependResult.WAITING;
            }
            if (dependentItem.getDepTaskCode() == 0L) {
                if (!processInstance.getState().typeIsFinished()) {
                    this.logger.info("Wait for the dependent workflow to complete, processDefiniteCode:{}, taskCode:{}, processInstanceId:{}, processInstance state:{}", new Object[]{dependentItem.getDefinitionCode(), dependentItem.getDepTaskCode(), processInstance.getId(), processInstance.getState()});
                    return DependResult.WAITING;
                }
                result = this.dependResultByProcessInstance(processInstance, dateInterval);
            } else {
                result = this.getDependTaskResult(processInstance, dependentItem.getDepTaskCode(), dateInterval);
            }
            if (result == DependResult.SUCCESS) continue;
            break;
        }
        return result;
    }

    private DependResult dependResultByProcessInstance(ProcessInstance processInstance, DateInterval dateInterval) {
        if (processInstance.getState().typeIsSuccess()) {
            List taskDefinitionLogs;
            Map<Long, String> definiteTask;
            List taskRelations = this.processService.findRelationByCode(processInstance.getProcessDefinitionCode().longValue(), processInstance.getProcessDefinitionVersion());
            if (!taskRelations.isEmpty() && !(definiteTask = (taskDefinitionLogs = this.processService.genTaskDefineList(taskRelations)).stream().filter(log -> !log.getTaskType().equals(TaskType.SUB_PROCESS.getDesc()) || !log.getTaskType().equals(TaskType.DEPENDENT.getDesc()) || !log.getTaskType().equals(TaskType.CONDITIONS.getDesc())).collect(Collectors.toMap(TaskDefinition::getCode, TaskDefinition::getName))).isEmpty()) {
                List taskInstanceList = this.processService.findLastTaskInstanceListInterval(definiteTask.keySet(), dateInterval);
                if (taskInstanceList.isEmpty()) {
                    this.logger.warn("Cannot find the task instance: {}", (Object)JSONUtils.toJsonString(definiteTask));
                    return DependResult.FAILED;
                }
                HashMap<Long, TaskInstance> taskInstanceMap = new HashMap<Long, TaskInstance>();
                for (TaskInstance instance2 : taskInstanceList) {
                    taskInstanceMap.compute(instance2.getTaskCode(), (k, v) -> {
                        if (v == null) {
                            v = instance2;
                        } else if (v.getId() < instance2.getId()) {
                            v = instance2;
                        }
                        return v;
                    });
                    definiteTask.remove(instance2.getTaskCode());
                }
                List instanceFail = taskInstanceMap.values().stream().filter(instance -> instance.getState().typeIsFailure()).collect(Collectors.toList());
                if (!instanceFail.isEmpty()) {
                    List log2 = instanceFail.stream().map(instance -> instance.getId() + "|" + instance.getTaskCode() + "|" + instance.getName()).collect(Collectors.toList());
                    this.logger.warn("The fail task: {}", (Object)StringUtils.join(log2, (String)","));
                    return DependResult.FAILED;
                }
                List instanceRunning = taskInstanceMap.values().stream().filter(instance -> instance.getState().typeIsRunning()).collect(Collectors.toList());
                if (!instanceRunning.isEmpty()) {
                    List log3 = instanceRunning.stream().map(instance -> instance.getId() + "|" + instance.getTaskCode() + "|" + instance.getName()).collect(Collectors.toList());
                    this.logger.info("The running task: {}", (Object)StringUtils.join(log3, (String)","));
                    return DependResult.WAITING;
                }
                if (!definiteTask.isEmpty()) {
                    this.logger.warn("Cannot find the task instance: {}", (Object)JSONUtils.toJsonString(definiteTask));
                    return DependResult.FAILED;
                }
            }
            return DependResult.SUCCESS;
        }
        return DependResult.FAILED;
    }

    private DependResult getDependTaskResult(ProcessInstance processInstance, long taskCode, DateInterval dateInterval) {
        DependResult result;
        TaskInstance taskInstance = this.processService.findLastTaskInstanceInterval(taskCode, dateInterval);
        if (taskInstance == null) {
            if (!processInstance.getState().typeIsFinished()) {
                this.logger.info("Wait for the dependent workflow to complete, taskCode:{}, processInstanceId:{}, processInstance state:{}", new Object[]{taskCode, processInstance.getId(), processInstance.getState()});
                return DependResult.WAITING;
            }
            TaskDefinition taskDefinition = this.processService.findTaskDefinitionByCode(taskCode);
            if (taskDefinition == null) {
                this.logger.error("Cannot find the task definition, something error, taskCode: {}", (Object)taskCode);
            } else {
                this.logger.warn("Cannot find the task in the process instance when the ProcessInstance is finish, taskCode: {}, taskName: {}", (Object)taskCode, (Object)taskDefinition.getName());
            }
            result = DependResult.FAILED;
        } else {
            this.logger.info("The running task, taskId:{}, taskCode:{}, taskName:{}", new Object[]{taskInstance.getId(), taskInstance.getTaskCode(), taskInstance.getName()});
            result = this.getDependResultByState(taskInstance.getState());
        }
        return result;
    }

    private ProcessInstance findLastProcessInterval(Long definitionCode, DateInterval dateInterval) {
        ProcessInstance runningProcess = this.processService.findLastRunningProcess(definitionCode, dateInterval.getStartTime(), dateInterval.getEndTime());
        if (runningProcess != null) {
            return runningProcess;
        }
        ProcessInstance lastSchedulerProcess = this.processService.findLastSchedulerProcessInterval(definitionCode, dateInterval);
        ProcessInstance lastManualProcess = this.processService.findLastManualProcessInterval(definitionCode, dateInterval);
        if (lastManualProcess == null) {
            return lastSchedulerProcess;
        }
        if (lastSchedulerProcess == null) {
            return lastManualProcess;
        }
        return lastManualProcess.getEndTime().after(lastSchedulerProcess.getEndTime()) ? lastManualProcess : lastSchedulerProcess;
    }

    private DependResult getDependResultByState(ExecutionStatus state) {
        if (!state.typeIsFinished()) {
            return DependResult.WAITING;
        }
        if (state.typeIsSuccess()) {
            return DependResult.SUCCESS;
        }
        return DependResult.FAILED;
    }

    public boolean finish(Date currentTime) {
        if (this.modelDependResult == DependResult.WAITING || this.modelDependResult == DependResult.NON_EXEC) {
            this.modelDependResult = this.getModelDependResult(currentTime);
            return this.modelDependResult == DependResult.SUCCESS || this.modelDependResult == DependResult.FAILED;
        }
        return true;
    }

    public DependResult getModelDependResult(Date currentTime) {
        ArrayList<DependResult> dependResultList = new ArrayList<DependResult>();
        for (DependentItem dependentItem : this.dependItemList) {
            DependResult dependResult = this.getDependResultForItem(dependentItem, currentTime);
            if (dependResult != DependResult.WAITING) {
                this.dependResultMap.put(dependentItem.getKey(), dependResult);
            }
            dependResultList.add(dependResult);
        }
        this.modelDependResult = DependentUtils.getDependResultForRelation((DependentRelation)this.relation, dependResultList);
        return this.modelDependResult;
    }

    private DependResult getDependResultForItem(DependentItem item, Date currentTime) {
        String key = item.getKey();
        if (this.dependResultMap.containsKey(key)) {
            return this.dependResultMap.get(key);
        }
        return this.getDependentResultForItem(item, currentTime);
    }

    public Map<String, DependResult> getDependResultMap() {
        return this.dependResultMap;
    }
}

