/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.PlaceholderUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.TimePlaceholderUtils;

public class ParameterUtils {
    private static final String DATE_PARSE_PATTERN = "\\$\\[([^\\$\\]]+)]";
    private static final String DATE_START_PATTERN = "^[0-9]";

    private ParameterUtils() {
        throw new UnsupportedOperationException("Construct ParameterUtils");
    }

    public static String convertParameterPlaceholders(String parameterString, Map<String, String> parameterMap) {
        Date cronTime;
        if (StringUtils.isEmpty((String)parameterString)) {
            return parameterString;
        }
        if (parameterMap != null && !parameterMap.isEmpty()) {
            parameterString = PlaceholderUtils.replacePlaceholders(parameterString, parameterMap, true);
        }
        if (parameterMap != null && null != parameterMap.get("system.datetime")) {
            String cronTimeStr = parameterMap.get("system.datetime");
            cronTime = DateUtils.parse(cronTimeStr, "yyyyMMddHHmmss");
        } else {
            cronTime = new Date();
        }
        if (cronTime != null) {
            return ParameterUtils.dateTemplateParse(parameterString, cronTime);
        }
        return parameterString;
    }

    public static String curingGlobalParams(Map<String, String> globalParamMap, List<Property> globalParamList, CommandType commandType, Date scheduleTime) {
        String val;
        if (globalParamList == null || globalParamList.isEmpty()) {
            return null;
        }
        HashMap<String, String> globalMap = new HashMap<String, String>();
        if (globalParamMap != null) {
            globalMap.putAll(globalParamMap);
        }
        HashMap<String, String> allParamMap = new HashMap<String, String>();
        Map<String, String> timeParams = BusinessTimeUtils.getBusinessTime(commandType, scheduleTime);
        if (timeParams != null) {
            allParamMap.putAll(timeParams);
        }
        allParamMap.putAll(globalMap);
        Set entries = allParamMap.entrySet();
        HashMap resolveMap = new HashMap();
        for (Map.Entry entry : entries) {
            val = (String)entry.getValue();
            if (!val.startsWith("$")) continue;
            String str = ParameterUtils.convertParameterPlaceholders(val, allParamMap);
            resolveMap.put(entry.getKey(), str);
        }
        globalMap.putAll(resolveMap);
        for (Property property : globalParamList) {
            val = (String)globalMap.get(property.getProp());
            if (val == null) continue;
            property.setValue(val);
        }
        return JSONUtils.toJsonString(globalParamList);
    }

    public static String handleEscapes(String inputString) {
        if (!StringUtils.isEmpty((String)inputString)) {
            return inputString.replace("%", "////%").replaceAll("[\n|\r\t]", "_");
        }
        return inputString;
    }

    public static Map<String, String> convert(Map<String, Property> paramsMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Property> en : paramsMap.entrySet()) {
            map.put(en.getKey(), en.getValue().getValue());
        }
        return map;
    }

    private static String dateTemplateParse(String templateStr, Date date) {
        if (templateStr == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(DATE_PARSE_PATTERN);
        StringBuffer newValue = new StringBuffer(templateStr.length());
        Matcher matcher = pattern.matcher(templateStr);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (Pattern.matches(DATE_START_PATTERN, key)) continue;
            String value = TimePlaceholderUtils.getPlaceHolderTime(key, date);
            assert (value != null);
            matcher.appendReplacement(newValue, value);
        }
        matcher.appendTail(newValue);
        return newValue.toString();
    }
}

