/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartBeat {
    private static final Logger logger = LoggerFactory.getLogger(HeartBeat.class);
    public static final String COMMA = ",";
    private long startupTime;
    private long reportTime = System.currentTimeMillis();
    private double cpuUsage;
    private double memoryUsage;
    private double loadAverage;
    private double availablePhysicalMemorySize;
    private double maxCpuloadAvg;
    private double reservedMemory;
    private int serverStatus = 0;
    private int processId;
    private int workerHostWeight;
    private int workerWaitingTaskCount;
    private int workerExecThreadCount;

    public long getStartupTime() {
        return this.startupTime;
    }

    public void setStartupTime(long startupTime) {
        this.startupTime = startupTime;
    }

    public long getReportTime() {
        return this.reportTime;
    }

    public void setReportTime(long reportTime) {
        this.reportTime = reportTime;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setMemoryUsage(double memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public double getLoadAverage() {
        return this.loadAverage;
    }

    public void setLoadAverage(double loadAverage) {
        this.loadAverage = loadAverage;
    }

    public double getAvailablePhysicalMemorySize() {
        return this.availablePhysicalMemorySize;
    }

    public void setAvailablePhysicalMemorySize(double availablePhysicalMemorySize) {
        this.availablePhysicalMemorySize = availablePhysicalMemorySize;
    }

    public double getMaxCpuloadAvg() {
        return this.maxCpuloadAvg;
    }

    public void setMaxCpuloadAvg(double maxCpuloadAvg) {
        this.maxCpuloadAvg = maxCpuloadAvg;
    }

    public double getReservedMemory() {
        return this.reservedMemory;
    }

    public void setReservedMemory(double reservedMemory) {
        this.reservedMemory = reservedMemory;
    }

    public int getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public int getWorkerHostWeight() {
        return this.workerHostWeight;
    }

    public void setWorkerHostWeight(int workerHostWeight) {
        this.workerHostWeight = workerHostWeight;
    }

    public int getWorkerWaitingTaskCount() {
        return this.workerWaitingTaskCount;
    }

    public void setWorkerWaitingTaskCount(int workerWaitingTaskCount) {
        this.workerWaitingTaskCount = workerWaitingTaskCount;
    }

    public int getWorkerExecThreadCount() {
        return this.workerExecThreadCount;
    }

    public void setWorkerExecThreadCount(int workerExecThreadCount) {
        this.workerExecThreadCount = workerExecThreadCount;
    }

    public HeartBeat() {
    }

    public HeartBeat(long startupTime, double maxCpuloadAvg, double reservedMemory) {
        this.startupTime = startupTime;
        this.maxCpuloadAvg = maxCpuloadAvg;
        this.reservedMemory = reservedMemory;
    }

    public HeartBeat(long startupTime, double maxCpuloadAvg, double reservedMemory, int hostWeight, int workerExecThreadCount) {
        this.startupTime = startupTime;
        this.maxCpuloadAvg = maxCpuloadAvg;
        this.reservedMemory = reservedMemory;
        this.workerHostWeight = hostWeight;
        this.workerExecThreadCount = workerExecThreadCount;
    }

    private void fillSystemInfo() {
        this.cpuUsage = OSUtils.cpuUsage();
        this.loadAverage = OSUtils.loadAverage();
        this.availablePhysicalMemorySize = OSUtils.availablePhysicalMemorySize();
        this.memoryUsage = OSUtils.memoryUsage();
        this.processId = OSUtils.getProcessID();
    }

    public void updateServerState() {
        this.reportTime = System.currentTimeMillis();
        if (this.loadAverage > this.maxCpuloadAvg || this.availablePhysicalMemorySize < this.reservedMemory) {
            logger.warn("current cpu load average {} is too high or available memory {}G is too low, under max.cpuload.avg={} and reserved.memory={}G", new Object[]{this.loadAverage, this.availablePhysicalMemorySize, this.maxCpuloadAvg, this.reservedMemory});
            this.serverStatus = 1;
        } else if (this.workerWaitingTaskCount > this.workerExecThreadCount) {
            logger.warn("current waiting task count {} is large than worker thread count {}, worker is busy", (Object)this.workerWaitingTaskCount, (Object)this.workerExecThreadCount);
            this.serverStatus = 2;
        } else {
            this.serverStatus = 0;
        }
    }

    public String encodeHeartBeat() {
        this.fillSystemInfo();
        this.updateServerState();
        StringBuilder builder = new StringBuilder(100);
        builder.append(this.cpuUsage).append(COMMA);
        builder.append(this.memoryUsage).append(COMMA);
        builder.append(this.loadAverage).append(COMMA);
        builder.append(this.availablePhysicalMemorySize).append(COMMA);
        builder.append(this.maxCpuloadAvg).append(COMMA);
        builder.append(this.reservedMemory).append(COMMA);
        builder.append(this.startupTime).append(COMMA);
        builder.append(this.reportTime).append(COMMA);
        builder.append(this.serverStatus).append(COMMA);
        builder.append(this.processId).append(COMMA);
        builder.append(this.workerHostWeight).append(COMMA);
        builder.append(this.workerExecThreadCount).append(COMMA);
        builder.append(this.workerWaitingTaskCount);
        return builder.toString();
    }

    public static HeartBeat decodeHeartBeat(String heartBeatInfo) {
        String[] parts = heartBeatInfo.split(COMMA);
        if (parts.length != 13) {
            return null;
        }
        HeartBeat heartBeat = new HeartBeat();
        heartBeat.cpuUsage = Double.parseDouble(parts[0]);
        heartBeat.memoryUsage = Double.parseDouble(parts[1]);
        heartBeat.loadAverage = Double.parseDouble(parts[2]);
        heartBeat.availablePhysicalMemorySize = Double.parseDouble(parts[3]);
        heartBeat.maxCpuloadAvg = Double.parseDouble(parts[4]);
        heartBeat.reservedMemory = Double.parseDouble(parts[5]);
        heartBeat.startupTime = Long.parseLong(parts[6]);
        heartBeat.reportTime = Long.parseLong(parts[7]);
        heartBeat.serverStatus = Integer.parseInt(parts[8]);
        heartBeat.processId = Integer.parseInt(parts[9]);
        heartBeat.workerHostWeight = Integer.parseInt(parts[10]);
        heartBeat.workerExecThreadCount = Integer.parseInt(parts[11]);
        heartBeat.workerWaitingTaskCount = Integer.parseInt(parts[12]);
        return heartBeat;
    }
}

