/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.plugin.task.util.OSUtils;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger logger = LoggerFactory.getLogger(ProcessUtils.class);
    private static final Pattern MACPATTERN = Pattern.compile("-[+|-]-\\s(\\d+)");
    private static final Pattern WINDOWSATTERN = Pattern.compile("(\\d+)");

    private ProcessUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static void kill(TaskRequest request) {
        try {
            int processId = request.getProcessId();
            if (processId == 0) {
                logger.error("process kill failed, process id :{}, task id:{}", (Object)processId, (Object)request.getTaskInstanceId());
                return;
            }
            String cmd = String.format("kill -9 %s", ProcessUtils.getPidsStr(processId));
            cmd = OSUtils.getSudoCmd(request.getTenantCode(), cmd);
            logger.info("process id:{}, cmd:{}", (Object)processId, (Object)cmd);
            OSUtils.exeCmd(cmd);
        }
        catch (Exception e) {
            logger.error("kill task failed", (Throwable)e);
        }
    }

    public static String getPidsStr(int processId) throws Exception {
        String pids;
        StringBuilder sb = new StringBuilder();
        Matcher mat = null;
        if (OSUtils.isMacOS()) {
            pids = OSUtils.exeCmd(String.format("%s -sp %d", "pstree", processId));
            if (null != pids) {
                mat = MACPATTERN.matcher(pids);
            }
        } else {
            pids = OSUtils.exeCmd(String.format("%s -p %d", "pstree", processId));
            mat = WINDOWSATTERN.matcher(pids);
        }
        if (null != mat) {
            while (mat.find()) {
                sb.append(mat.group(1)).append(" ");
            }
        }
        return sb.toString().trim();
    }
}

