/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.dingtalk;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DingTalkSender {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkSender.class);
    private final String url;
    private final String keyword;
    private final String secret;
    private final Boolean enableProxy;
    private String proxy;
    private Integer port;
    private String user;
    private String password;

    DingTalkSender(Map<String, String> config) {
        this.url = config.get("WebHook");
        this.keyword = config.get("Keyword");
        this.secret = config.get("Secret");
        this.enableProxy = Boolean.valueOf(config.get("IsEnableProxy"));
        if (Boolean.TRUE.equals(this.enableProxy)) {
            this.port = Integer.parseInt(config.get("Port"));
            this.proxy = config.get("Proxy");
            this.user = config.get("user");
            this.password = config.get("Password");
        }
    }

    private static HttpPost constructHttpPost(String url, String msg) {
        HttpPost post = new HttpPost(url);
        StringEntity entity = new StringEntity(msg, StandardCharsets.UTF_8);
        post.setEntity((HttpEntity)entity);
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        return post;
    }

    private static CloseableHttpClient getProxyClient(String proxy, int port, String user, String password) {
        HttpHost httpProxy = new HttpHost(proxy, port);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(httpProxy), (Credentials)new UsernamePasswordCredentials(user, password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    private static CloseableHttpClient getDefaultClient() {
        return HttpClients.createDefault();
    }

    private static RequestConfig getProxyConfig(String proxy, int port) {
        HttpHost httpProxy = new HttpHost(proxy, port);
        return RequestConfig.custom().setProxy(httpProxy).build();
    }

    private static String textToJsonString(String text) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("msgtype", "text");
        HashMap<String, String> textContent = new HashMap<String, String>();
        byte[] byt = org.apache.commons.codec.binary.StringUtils.getBytesUtf8((String)text);
        String txt = org.apache.commons.codec.binary.StringUtils.newStringUtf8((byte[])byt);
        textContent.put("content", txt);
        items.put("text", textContent);
        return JSONUtils.toJsonString(items);
    }

    private static AlertResult checkSendDingTalkSendMsgResult(String result) {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus("false");
        if (null == result) {
            alertResult.setMessage("send ding talk msg error");
            logger.info("send ding talk msg error,ding talk server resp is null");
            return alertResult;
        }
        DingTalkSendMsgResponse sendMsgResponse = (DingTalkSendMsgResponse)JSONUtils.parseObject((String)result, DingTalkSendMsgResponse.class);
        if (null == sendMsgResponse) {
            alertResult.setMessage("send ding talk msg fail");
            logger.info("send ding talk msg error,resp error");
            return alertResult;
        }
        if (sendMsgResponse.errcode == 0) {
            alertResult.setStatus("true");
            alertResult.setMessage("send ding talk msg success");
            return alertResult;
        }
        alertResult.setMessage(String.format("alert send ding talk msg error : %s", sendMsgResponse.getErrmsg()));
        logger.info("alert send ding talk msg error : {}", (Object)sendMsgResponse.getErrmsg());
        return alertResult;
    }

    public AlertResult sendDingTalkMsg(String title, String content) {
        try {
            String resp = this.sendMsg(title, content);
            return DingTalkSender.checkSendDingTalkSendMsgResult(resp);
        }
        catch (Exception e) {
            logger.info("send ding talk alert msg  exception : {}", (Object)e.getMessage());
            AlertResult alertResult = new AlertResult();
            alertResult.setStatus("false");
            alertResult.setMessage("send ding talk alert fail.");
            return alertResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendMsg(String title, String content) throws IOException {
        CloseableHttpClient httpClient;
        StringBuilder text = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.keyword)) {
            text.append(this.keyword);
            text.append(":");
        }
        text.append(title);
        text.append("\n");
        text.append(content);
        String msgToJson = DingTalkSender.textToJsonString(text.toString());
        HttpPost httpPost = DingTalkSender.constructHttpPost(StringUtils.isBlank((CharSequence)this.secret) ? this.url : this.generateSignedUrl(), msgToJson);
        if (Boolean.TRUE.equals(this.enableProxy)) {
            httpClient = DingTalkSender.getProxyClient(this.proxy, this.port, this.user, this.password);
            RequestConfig rcf = DingTalkSender.getProxyConfig(this.proxy, this.port);
            httpPost.setConfig(rcf);
        } else {
            httpClient = DingTalkSender.getDefaultClient();
        }
        try {
            String resp;
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            logger.info("Ding Talk send title :{},content : {}, resp: {}", new Object[]{title, content, resp});
            String string = resp;
            return string;
        }
        finally {
            httpClient.close();
        }
    }

    private String generateSignedUrl() {
        Long timestamp = System.currentTimeMillis();
        String stringToSign = timestamp + "\n" + this.secret;
        String sign = "";
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.secret.getBytes("UTF-8"), "HmacSHA256"));
            byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
            sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
        }
        catch (Exception e) {
            logger.error("generate sign error, message:{}", (Throwable)e);
        }
        return this.url + "&timestamp=" + timestamp + "&sign=" + sign;
    }

    static final class DingTalkSendMsgResponse {
        private Integer errcode;
        private String errmsg;

        public Integer getErrcode() {
            return this.errcode;
        }

        public void setErrcode(Integer errcode) {
            this.errcode = errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DingTalkSendMsgResponse)) {
                return false;
            }
            DingTalkSendMsgResponse other = (DingTalkSendMsgResponse)o;
            Integer this$errcode = this.getErrcode();
            Integer other$errcode = other.getErrcode();
            if (this$errcode == null ? other$errcode != null : !((Object)this$errcode).equals(other$errcode)) {
                return false;
            }
            String this$errmsg = this.getErrmsg();
            String other$errmsg = other.getErrmsg();
            return !(this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $errcode = this.getErrcode();
            result = result * 59 + ($errcode == null ? 43 : ((Object)$errcode).hashCode());
            String $errmsg = this.getErrmsg();
            result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
            return result;
        }

        public String toString() {
            return "DingTalkSender.DingTalkSendMsgResponse(errcode=" + this.getErrcode() + ", errmsg=" + this.getErrmsg() + ")";
        }
    }
}

