/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZookeeperConnectionStateListener
implements ConnectionStateListener {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperConnectionStateListener.class);
    private final ConnectionListener listener;

    public ZookeeperConnectionStateListener(ConnectionListener listener) {
        this.listener = listener;
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        switch (newState) {
            case LOST: {
                log.warn("Registry disconnected");
                this.listener.onUpdate(org.apache.dolphinscheduler.registry.api.ConnectionState.DISCONNECTED);
                break;
            }
            case RECONNECTED: {
                log.info("Registry reconnected");
                this.listener.onUpdate(org.apache.dolphinscheduler.registry.api.ConnectionState.RECONNECTED);
                break;
            }
            case SUSPENDED: {
                log.warn("Registry suspended");
                this.listener.onUpdate(org.apache.dolphinscheduler.registry.api.ConnectionState.SUSPENDED);
                break;
            }
        }
    }
}

