/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.TaskDefinitionService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.api.utils.CheckUtils;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.AuthorizationType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.UserMapper;
import org.apache.dolphinscheduler.service.permission.PermissionCheck;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskDefinitionServiceImpl
extends BaseServiceImpl
implements TaskDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(TaskDefinitionServiceImpl.class);
    private static final String RELEASESTATE = "releaseState";
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private ProcessTaskRelationLogMapper processTaskRelationLogMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private UserMapper userMapper;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> createTaskDefinition(User loginUser, long projectCode, String taskDefinitionJson) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List taskDefinitionLogs = JSONUtils.toList((String)taskDefinitionJson, TaskDefinitionLog.class);
        if (taskDefinitionLogs.isEmpty()) {
            logger.error("taskDefinitionJson invalid: {}", (Object)taskDefinitionJson);
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJson);
            return result;
        }
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            if (CheckUtils.checkTaskDefinitionParameters((TaskDefinition)taskDefinitionLog)) continue;
            logger.error("task definition {} parameter invalid", (Object)taskDefinitionLog.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionLog.getName());
            return result;
        }
        int saveTaskResult = this.processService.saveTaskDefine(loginUser, projectCode, taskDefinitionLogs, Boolean.TRUE);
        if (saveTaskResult == -1) {
            this.putMsg(result, Status.CREATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_TASK_DEFINITION_ERROR);
        }
        HashMap<String, Object> resData = new HashMap<String, Object>();
        resData.put("total", taskDefinitionLogs.size());
        resData.put("code", StringUtils.join((Collection)taskDefinitionLogs.stream().map(TaskDefinition::getCode).collect(Collectors.toList()), (String)","));
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", resData);
        return result;
    }

    @Override
    public Map<String, Object> queryTaskDefinitionByName(User loginUser, long projectCode, String taskName) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByName(project.getCode(), taskName);
        if (taskDefinition == null) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskName);
        } else {
            result.put("data", taskDefinition);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteTaskDefinitionByCode(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (taskCode == 0L) {
            this.putMsg(result, Status.DELETE_TASK_DEFINE_BY_CODE_ERROR, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskCode);
            return result;
        }
        if (taskDefinition.getFlag() == Flag.YES) {
            this.putMsg(result, Status.TASK_DEFINE_STATE_ONLINE, taskCode);
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryDownstreamByTaskCode(taskCode);
        if (!processTaskRelationList.isEmpty()) {
            Set postTaskCodes = processTaskRelationList.stream().map(ProcessTaskRelation::getPostTaskCode).collect(Collectors.toSet());
            this.putMsg(result, Status.TASK_HAS_DOWNSTREAM, StringUtils.join(postTaskCodes, (String)","));
            return result;
        }
        int delete = this.taskDefinitionMapper.deleteByCode(taskCode);
        if (delete > 0) {
            List taskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
            if (!taskRelationList.isEmpty()) {
                int deleteRelation = 0;
                for (ProcessTaskRelation processTaskRelation : taskRelationList) {
                    deleteRelation += this.processTaskRelationMapper.deleteById((Serializable)Integer.valueOf(processTaskRelation.getId()));
                }
                if (deleteRelation == 0) {
                    throw new ServiceException(Status.DELETE_TASK_PROCESS_RELATION_ERROR);
                }
                long processDefinitionCode = ((ProcessTaskRelation)taskRelationList.get(0)).getProcessDefinitionCode();
                this.updateProcessDefiniteVersion(loginUser, processDefinitionCode);
            }
        } else {
            this.putMsg(result, Status.DELETE_TASK_DEFINE_BY_CODE_ERROR, new Object[0]);
            throw new ServiceException(Status.DELETE_TASK_DEFINE_BY_CODE_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private int updateProcessDefiniteVersion(User loginUser, long processDefinitionCode) {
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST);
        }
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion <= 0) {
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        return insertVersion;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> updateTaskDefinition(User loginUser, long projectCode, long taskCode, String taskDefinitionJsonObj) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskCode);
            return result;
        }
        if (this.processService.isTaskOnline(taskCode) && taskDefinition.getFlag() == Flag.YES) {
            this.putMsg(result, Status.NOT_SUPPORT_UPDATE_TASK_DEFINITION, new Object[0]);
            return result;
        }
        TaskDefinitionLog taskDefinitionToUpdate = (TaskDefinitionLog)JSONUtils.parseObject((String)taskDefinitionJsonObj, TaskDefinitionLog.class);
        if (taskDefinitionToUpdate == null) {
            logger.error("taskDefinitionJson is not valid json");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskDefinitionJsonObj);
            return result;
        }
        if (!CheckUtils.checkTaskDefinitionParameters((TaskDefinition)taskDefinitionToUpdate)) {
            logger.error("task definition {} parameter invalid", (Object)taskDefinitionToUpdate.getName());
            this.putMsg(result, Status.PROCESS_NODE_S_PARAMETER_INVALID, taskDefinitionToUpdate.getName());
            return result;
        }
        Integer version = this.taskDefinitionLogMapper.queryMaxVersionForDefinition(taskCode);
        if (version == null || version == 0) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, taskCode);
            return result;
        }
        Date now = new Date();
        taskDefinitionToUpdate.setCode(taskCode);
        taskDefinitionToUpdate.setId(taskDefinition.getId());
        taskDefinitionToUpdate.setProjectCode(projectCode);
        taskDefinitionToUpdate.setUserId(taskDefinition.getUserId());
        version = version + 1;
        taskDefinitionToUpdate.setVersion(version.intValue());
        taskDefinitionToUpdate.setTaskType(taskDefinitionToUpdate.getTaskType().toUpperCase());
        taskDefinitionToUpdate.setResourceIds(this.processService.getResourceIds((TaskDefinition)taskDefinitionToUpdate));
        taskDefinitionToUpdate.setUpdateTime(now);
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinitionToUpdate);
        taskDefinitionToUpdate.setOperator(loginUser.getId());
        taskDefinitionToUpdate.setOperateTime(now);
        taskDefinitionToUpdate.setCreateTime(now);
        int insert = this.taskDefinitionLogMapper.insert((Object)taskDefinitionToUpdate);
        if ((update & insert) != 1) {
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        this.handleRelation(loginUser, taskCode, version, now);
        result.put("data", taskCode);
        this.putMsg(result, Status.SUCCESS, update);
        return result;
    }

    private void handleRelation(User loginUser, long taskCode, Integer version, Date now) {
        List processTaskRelationList = this.processTaskRelationMapper.queryByTaskCode(taskCode);
        if (!processTaskRelationList.isEmpty()) {
            int insertRelationLog;
            long processDefinitionCode = ((ProcessTaskRelation)processTaskRelationList.get(0)).getProcessDefinitionCode();
            int definiteVersion = this.updateProcessDefiniteVersion(loginUser, processDefinitionCode);
            ArrayList<ProcessTaskRelationLog> processTaskRelationLogList = new ArrayList<ProcessTaskRelationLog>();
            int delete = 0;
            for (ProcessTaskRelation processTaskRelation : processTaskRelationList) {
                ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog(processTaskRelation);
                delete += this.processTaskRelationMapper.deleteRelation(processTaskRelationLog);
                if (processTaskRelationLog.getPreTaskCode() == taskCode) {
                    processTaskRelationLog.setPreTaskVersion(version.intValue());
                }
                if (processTaskRelationLog.getPostTaskCode() == taskCode) {
                    processTaskRelationLog.setPostTaskVersion(version.intValue());
                }
                processTaskRelationLog.setProcessDefinitionVersion(definiteVersion);
                processTaskRelationLog.setOperator(loginUser.getId());
                processTaskRelationLog.setOperateTime(now);
                processTaskRelationLog.setUpdateTime(now);
                processTaskRelationLogList.add(processTaskRelationLog);
            }
            if (delete == 0) {
                throw new ServiceException(Status.DELETE_TASK_PROCESS_RELATION_ERROR);
            }
            int insertRelation = this.processTaskRelationMapper.batchInsert(processTaskRelationLogList);
            if ((insertRelation & (insertRelationLog = this.processTaskRelationLogMapper.batchInsert(processTaskRelationLogList))) == 0) {
                throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR);
            }
        }
    }

    @Override
    public Map<String, Object> switchVersion(User loginUser, long projectCode, long taskCode, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (this.processService.isTaskOnline(taskCode)) {
            this.putMsg(result, Status.PROCESS_DEFINE_STATE_ONLINE, new Object[0]);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskCode);
            return result;
        }
        TaskDefinitionLog taskDefinitionUpdate = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(taskCode, version);
        taskDefinitionUpdate.setUserId(loginUser.getId());
        Date now = new Date();
        taskDefinitionUpdate.setUpdateTime(new Date());
        taskDefinitionUpdate.setId(taskDefinition.getId());
        int switchVersion = this.taskDefinitionMapper.updateById((Object)taskDefinitionUpdate);
        if (switchVersion > 0) {
            this.handleRelation(loginUser, taskCode, version, now);
            result.put("data", taskCode);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        } else {
            this.putMsg(result, Status.SWITCH_TASK_DEFINITION_VERSION_ERROR, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryTaskDefinitionVersions(User loginUser, long projectCode, long taskCode, int pageNo, int pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage taskDefinitionVersionsPaging = this.taskDefinitionLogMapper.queryTaskDefinitionVersionsPaging(page, taskCode, projectCode);
        List taskDefinitionLogs = taskDefinitionVersionsPaging.getRecords();
        pageInfo.setTotalList(taskDefinitionLogs);
        pageInfo.setTotal((int)taskDefinitionVersionsPaging.getTotal());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> deleteByCodeAndVersion(User loginUser, long projectCode, long taskCode, int version) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskCode);
        } else {
            if (taskDefinition.getVersion() == version) {
                this.putMsg(result, Status.MAIN_TABLE_USING_VERSION, new Object[0]);
                return result;
            }
            int delete = this.taskDefinitionLogMapper.deleteByCodeAndVersion(taskCode, version);
            if (delete > 0) {
                this.putMsg(result, Status.SUCCESS, new Object[0]);
            } else {
                this.putMsg(result, Status.DELETE_TASK_DEFINITION_VERSION_ERROR, new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> queryTaskDefinitionDetail(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskCode);
        } else {
            result.put("data", taskDefinition);
            this.putMsg(result, Status.SUCCESS, new Object[0]);
        }
        return result;
    }

    @Override
    public Result queryTaskDefinitionListPaging(User loginUser, long projectCode, String taskType, String searchVal, Integer userId, Integer pageNo, Integer pageSize) {
        Result result = new Result();
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> checkResult = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        Status resultStatus = (Status)((Object)checkResult.get("status"));
        if (resultStatus != Status.SUCCESS) {
            this.putMsg(result, resultStatus, new Object[0]);
            return result;
        }
        if (StringUtils.isNotBlank((String)taskType)) {
            taskType = taskType.toUpperCase();
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage taskDefinitionIPage = this.taskDefinitionMapper.queryDefineListPaging((IPage)page, projectCode, taskType, searchVal, userId.intValue(), this.isAdmin(loginUser));
        if (StringUtils.isNotBlank((String)taskType)) {
            List records = taskDefinitionIPage.getRecords();
            for (TaskDefinition pd : records) {
                TaskDefinitionLog taskDefinitionLog = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(pd.getCode(), pd.getVersion());
                User user = this.userMapper.selectById(taskDefinitionLog.getOperator());
                pd.setModifyBy(user.getUserName());
            }
            taskDefinitionIPage.setRecords(records);
        }
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        pageInfo.setTotal((int)taskDefinitionIPage.getTotal());
        pageInfo.setTotalList(taskDefinitionIPage.getRecords());
        result.setData(pageInfo);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> genTaskCodeList(Integer genNum) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (genNum == null || genNum < 1 || genNum > 100) {
            logger.error("the genNum must be great than 1 and less than 100");
            this.putMsg(result, Status.DATA_IS_NOT_VALID, genNum);
            return result;
        }
        ArrayList<Long> taskCodes = new ArrayList<Long>();
        try {
            for (int i = 0; i < genNum; ++i) {
                taskCodes.add(CodeGenerateUtils.getInstance().genCode());
            }
        }
        catch (CodeGenerateUtils.CodeGenerateException e) {
            logger.error("Task code get error, ", (Throwable)e);
            this.putMsg(result, Status.INTERNAL_SERVER_ERROR_ARGS, "Error generating task definition code");
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        result.put("data", taskCodes);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> releaseTaskDefinition(User loginUser, long projectCode, long code, ReleaseState releaseState) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        Status resultStatus = (Status)((Object)result.get("status"));
        if (resultStatus != Status.SUCCESS) {
            return result;
        }
        if (null == releaseState) {
            this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, RELEASESTATE);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(code);
        if (taskDefinition == null || projectCode != taskDefinition.getProjectCode()) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, code);
            return result;
        }
        TaskDefinitionLog taskDefinitionLog = this.taskDefinitionLogMapper.queryByDefinitionCodeAndVersion(code, taskDefinition.getVersion());
        if (taskDefinitionLog == null) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, code);
            return result;
        }
        switch (releaseState) {
            case OFFLINE: {
                taskDefinition.setFlag(Flag.NO);
                taskDefinitionLog.setFlag(Flag.NO);
                break;
            }
            case ONLINE: {
                String resourceIds = taskDefinition.getResourceIds();
                if (StringUtils.isNotBlank((String)resourceIds)) {
                    Object[] resourceIdArray = (Integer[])Arrays.stream(resourceIds.split(",")).map(Integer::parseInt).toArray(Integer[]::new);
                    PermissionCheck permissionCheck = new PermissionCheck(AuthorizationType.RESOURCE_FILE_ID, this.processService, resourceIdArray, loginUser.getId(), logger);
                    try {
                        permissionCheck.checkPermission();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        this.putMsg(result, Status.RESOURCE_NOT_EXIST_OR_NO_PERMISSION, new Object[0]);
                        return result;
                    }
                }
                taskDefinition.setFlag(Flag.YES);
                taskDefinitionLog.setFlag(Flag.NO);
                break;
            }
            default: {
                this.putMsg(result, Status.REQUEST_PARAMS_NOT_VALID_ERROR, RELEASESTATE);
                return result;
            }
        }
        int update = this.taskDefinitionMapper.updateById((Object)taskDefinition);
        int updateLog = this.taskDefinitionLogMapper.updateById(taskDefinitionLog);
        if (update == 0 && updateLog == 1 || update == 1 && updateLog == 0) {
            this.putMsg(result, Status.UPDATE_TASK_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_TASK_DEFINITION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }
}

