/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.service.ProcessTaskRelationService;
import org.apache.dolphinscheduler.api.service.ProjectService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.enums.ConditionType;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelation;
import org.apache.dolphinscheduler.dao.entity.ProcessTaskRelationLog;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.mapper.ProcessDefinitionMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationLogMapper;
import org.apache.dolphinscheduler.dao.mapper.ProcessTaskRelationMapper;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionMapper;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessTaskRelationServiceImpl
extends BaseServiceImpl
implements ProcessTaskRelationService {
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private ProjectService projectService;
    @Autowired
    private ProcessTaskRelationMapper processTaskRelationMapper;
    @Autowired
    private ProcessTaskRelationLogMapper processTaskRelationLogMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;
    @Autowired
    private TaskDefinitionMapper taskDefinitionMapper;
    @Autowired
    private ProcessDefinitionMapper processDefinitionMapper;
    @Autowired
    private ProcessService processService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> createProcessTaskRelation(User loginUser, long projectCode, long processDefinitionCode, long preTaskCode, long postTaskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processDefinitionCode);
            return result;
        }
        if (processDefinition.getProjectCode() != projectCode) {
            this.putMsg(result, Status.PROJECT_PROCESS_NOT_MATCH, new Object[0]);
            return result;
        }
        List processTaskRelations = this.processTaskRelationMapper.queryByCode(projectCode, processDefinitionCode, 0L, postTaskCode);
        if (!processTaskRelations.isEmpty()) {
            int deleteLog;
            ProcessTaskRelationLog processTaskRelationLog;
            int delete;
            Map<Long, ProcessTaskRelation> preTaskCodeMap = processTaskRelations.stream().collect(Collectors.toMap(ProcessTaskRelation::getPreTaskCode, processTaskRelation -> processTaskRelation));
            if (preTaskCodeMap.containsKey(preTaskCode) || !preTaskCodeMap.containsKey(0L) && preTaskCode == 0L) {
                this.putMsg(result, Status.PROCESS_TASK_RELATION_EXIST, processDefinitionCode);
                return result;
            }
            if (preTaskCodeMap.containsKey(0L) && preTaskCode != 0L && ((delete = this.processTaskRelationMapper.deleteRelation(processTaskRelationLog = new ProcessTaskRelationLog(preTaskCodeMap.get(0L)))) & (deleteLog = this.processTaskRelationLogMapper.deleteRelation(processTaskRelationLog))) == 0) {
                this.putMsg(result, Status.CREATE_PROCESS_TASK_RELATION_ERROR, new Object[0]);
                throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR);
            }
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        Date now = new Date();
        ArrayList<ProcessTaskRelationLog> processTaskRelationLogs = new ArrayList<ProcessTaskRelationLog>();
        if (preTaskCode != 0L) {
            List upstreamProcessTaskRelations = this.processTaskRelationMapper.queryByCode(projectCode, processDefinitionCode, 0L, preTaskCode);
            TaskDefinition preTaskDefinition = this.taskDefinitionMapper.queryByCode(preTaskCode);
            if (upstreamProcessTaskRelations.isEmpty()) {
                ProcessTaskRelationLog processTaskRelationLog = this.setRelationLog(processDefinition, now, loginUser.getId(), preTaskDefinition);
                processTaskRelationLog.setPreTaskCode(0L);
                processTaskRelationLog.setPreTaskVersion(0);
                processTaskRelationLogs.add(processTaskRelationLog);
            }
            TaskDefinition postTaskDefinition = this.taskDefinitionMapper.queryByCode(postTaskCode);
            ProcessTaskRelationLog processTaskRelationLog = this.setRelationLog(processDefinition, now, loginUser.getId(), postTaskDefinition);
            processTaskRelationLog.setPreTaskCode(preTaskDefinition.getCode());
            processTaskRelationLog.setPreTaskVersion(preTaskDefinition.getVersion());
            processTaskRelationLogs.add(processTaskRelationLog);
        } else {
            TaskDefinition postTaskDefinition = this.taskDefinitionMapper.queryByCode(postTaskCode);
            ProcessTaskRelationLog processTaskRelationLog = this.setRelationLog(processDefinition, now, loginUser.getId(), postTaskDefinition);
            processTaskRelationLog.setPreTaskCode(0L);
            processTaskRelationLog.setPreTaskVersion(0);
            processTaskRelationLogs.add(processTaskRelationLog);
        }
        int insert = this.processTaskRelationMapper.batchInsert(processTaskRelationLogs);
        int insertLog = this.processTaskRelationLogMapper.batchInsert(processTaskRelationLogs);
        if ((insert & insertLog) <= 0) {
            this.putMsg(result, Status.CREATE_PROCESS_TASK_RELATION_ERROR, new Object[0]);
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private ProcessTaskRelationLog setRelationLog(ProcessDefinition processDefinition, Date now, int userId, TaskDefinition taskDefinition) {
        ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog();
        processTaskRelationLog.setProjectCode(processDefinition.getProjectCode());
        processTaskRelationLog.setProcessDefinitionCode(processDefinition.getCode());
        processTaskRelationLog.setProcessDefinitionVersion(processDefinition.getVersion());
        processTaskRelationLog.setPostTaskCode(taskDefinition.getCode());
        processTaskRelationLog.setPostTaskVersion(taskDefinition.getVersion());
        processTaskRelationLog.setConditionType(ConditionType.NONE);
        processTaskRelationLog.setConditionParams("{}");
        processTaskRelationLog.setCreateTime(now);
        processTaskRelationLog.setUpdateTime(now);
        processTaskRelationLog.setOperator(userId);
        processTaskRelationLog.setOperateTime(now);
        return processTaskRelationLog;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> moveTaskProcessRelation(User loginUser, long projectCode, long processDefinitionCode, long targetProcessDefinitionCode, long taskCode) {
        long subProcessDefinitionCode;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(targetProcessDefinitionCode);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, targetProcessDefinitionCode);
            return result;
        }
        if (processDefinition.getProjectCode() != projectCode) {
            this.putMsg(result, Status.PROJECT_PROCESS_NOT_MATCH, new Object[0]);
            return result;
        }
        List downstreamList = this.processTaskRelationMapper.queryByCode(projectCode, processDefinitionCode, taskCode, 0L);
        if (CollectionUtils.isNotEmpty((Collection)downstreamList)) {
            Set postTaskCodes = downstreamList.stream().map(ProcessTaskRelation::getPostTaskCode).collect(Collectors.toSet());
            this.putMsg(result, Status.TASK_HAS_DOWNSTREAM, StringUtils.join(postTaskCodes, (String)","));
            return result;
        }
        List upstreamList = this.processTaskRelationMapper.queryByCode(projectCode, processDefinitionCode, 0L, taskCode);
        if (upstreamList.isEmpty()) {
            this.putMsg(result, Status.PROCESS_TASK_RELATION_NOT_EXIST, "taskCode:" + taskCode);
            return result;
        }
        Set preTaskCodes = upstreamList.stream().map(ProcessTaskRelation::getPreTaskCode).collect(Collectors.toSet());
        if (preTaskCodes.size() > 1 || !preTaskCodes.contains(0L)) {
            this.putMsg(result, Status.TASK_HAS_UPSTREAM, StringUtils.join(preTaskCodes, (String)","));
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (null == taskDefinition) {
            this.putMsg(result, Status.DATA_IS_NULL, "taskDefinition");
            return result;
        }
        ObjectNode paramNode = JSONUtils.parseObject((String)taskDefinition.getTaskParams());
        if (TaskType.DEPENDENT.getDesc().equals(taskDefinition.getTaskType())) {
            HashSet<Long> depProcessDefinitionCodes = new HashSet<Long>();
            ObjectNode dependence = (ObjectNode)paramNode.get("dependence");
            ArrayNode dependTaskList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependence.get("dependTaskList")));
            for (int i = 0; i < dependTaskList.size(); ++i) {
                ObjectNode dependTask = (ObjectNode)dependTaskList.path(i);
                ArrayNode dependItemList = JSONUtils.parseArray((String)JSONUtils.toJsonString((Object)dependTask.get("dependItemList")));
                for (int j = 0; j < dependItemList.size(); ++j) {
                    ObjectNode dependItem = (ObjectNode)dependItemList.path(j);
                    long definitionCode = dependItem.get("definitionCode").asLong();
                    depProcessDefinitionCodes.add(definitionCode);
                }
            }
            if (depProcessDefinitionCodes.contains(targetProcessDefinitionCode)) {
                this.putMsg(result, Status.DATA_IS_NOT_VALID, "targetProcessDefinitionCode");
                return result;
            }
        }
        if (TaskType.SUB_PROCESS.getDesc().equals(taskDefinition.getTaskType()) && targetProcessDefinitionCode == (subProcessDefinitionCode = paramNode.get("processDefinitionCode").asLong())) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "targetProcessDefinitionCode");
            return result;
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        Date now = new Date();
        ProcessTaskRelation processTaskRelation = (ProcessTaskRelation)upstreamList.get(0);
        ProcessTaskRelationLog processTaskRelationLog = this.processTaskRelationLogMapper.queryRelationLogByRelation(processTaskRelation);
        processTaskRelation.setProcessDefinitionCode(processDefinition.getCode());
        processTaskRelation.setProcessDefinitionVersion(processDefinition.getVersion());
        processTaskRelation.setUpdateTime(now);
        processTaskRelationLog.setProcessDefinitionCode(processDefinition.getCode());
        processTaskRelationLog.setProcessDefinitionVersion(processDefinition.getVersion());
        processTaskRelationLog.setUpdateTime(now);
        processTaskRelationLog.setOperator(loginUser.getId());
        processTaskRelationLog.setOperateTime(now);
        int update = this.processTaskRelationMapper.updateById(processTaskRelation);
        int updateLog = this.processTaskRelationLogMapper.updateById((Object)processTaskRelationLog);
        if (update == 0 || updateLog == 0) {
            this.putMsg(result, Status.MOVE_PROCESS_TASK_RELATION_ERROR, new Object[0]);
            throw new ServiceException(Status.MOVE_PROCESS_TASK_RELATION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void updateProcessDefiniteVersion(User loginUser, Map<String, Object> result, ProcessDefinition processDefinition) {
        int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.TRUE, Boolean.TRUE);
        if (insertVersion <= 0) {
            this.putMsg(result, Status.UPDATE_PROCESS_DEFINITION_ERROR, new Object[0]);
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        processDefinition.setVersion(insertVersion);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteTaskProcessRelation(User loginUser, long projectCode, long processDefinitionCode, long taskCode) {
        int deleteTaskDefinition;
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (taskCode == 0L) {
            this.putMsg(result, Status.DELETE_TASK_PROCESS_RELATION_ERROR, new Object[0]);
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processDefinitionCode);
            return result;
        }
        TaskDefinition taskDefinition = this.taskDefinitionMapper.queryByCode(taskCode);
        if (null == taskDefinition) {
            this.putMsg(result, Status.TASK_DEFINE_NOT_EXIST, taskCode);
            return result;
        }
        List downstreamList = this.processTaskRelationMapper.queryByCode(projectCode, processDefinitionCode, taskCode, 0L);
        if (CollectionUtils.isNotEmpty((Collection)downstreamList)) {
            Set postTaskCodes = downstreamList.stream().map(ProcessTaskRelation::getPostTaskCode).collect(Collectors.toSet());
            this.putMsg(result, Status.TASK_HAS_DOWNSTREAM, StringUtils.join(postTaskCodes, (String)","));
            return result;
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog();
        processTaskRelationLog.setProjectCode(projectCode);
        processTaskRelationLog.setPostTaskCode(taskCode);
        processTaskRelationLog.setPostTaskVersion(taskDefinition.getVersion());
        processTaskRelationLog.setProcessDefinitionCode(processDefinitionCode);
        processTaskRelationLog.setProcessDefinitionVersion(processDefinition.getVersion());
        int deleteRelation = this.processTaskRelationMapper.deleteRelation(processTaskRelationLog);
        int deleteRelationLog = this.processTaskRelationLogMapper.deleteRelation(processTaskRelationLog);
        if (0 == deleteRelation || 0 == deleteRelationLog) {
            this.putMsg(result, Status.DELETE_TASK_PROCESS_RELATION_ERROR, new Object[0]);
            throw new ServiceException(Status.DELETE_TASK_PROCESS_RELATION_ERROR);
        }
        if ((TaskType.CONDITIONS.getDesc().equals(taskDefinition.getTaskType()) || TaskType.DEPENDENT.getDesc().equals(taskDefinition.getTaskType()) || TaskType.SUB_PROCESS.getDesc().equals(taskDefinition.getTaskType())) && 0 == (deleteTaskDefinition = this.taskDefinitionMapper.deleteByCode(taskCode))) {
            this.putMsg(result, Status.DELETE_TASK_DEFINE_BY_CODE_ERROR, new Object[0]);
            throw new ServiceException(Status.DELETE_TASK_DEFINE_BY_CODE_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteUpstreamRelation(User loginUser, long projectCode, String preTaskCodes, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (org.apache.dolphinscheduler.spi.utils.StringUtils.isEmpty((CharSequence)preTaskCodes)) {
            this.putMsg(result, Status.DATA_IS_NULL, "preTaskCodes");
            return result;
        }
        Status status = this.deleteUpstreamRelation(loginUser, projectCode, (Long[])Lists.newArrayList((Object[])preTaskCodes.split(",")).stream().map(Long::parseLong).distinct().toArray(Long[]::new), taskCode);
        if (status != Status.SUCCESS) {
            this.putMsg(result, status, new Object[0]);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteDownstreamRelation(User loginUser, long projectCode, String postTaskCodes, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        if (org.apache.dolphinscheduler.spi.utils.StringUtils.isEmpty((CharSequence)postTaskCodes)) {
            this.putMsg(result, Status.DATA_IS_NULL, "postTaskCodes");
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryDownstreamByCode(projectCode, taskCode);
        Map<Long, ProcessTaskRelationLog> taskRelationLogMap = processTaskRelationList.stream().map(ProcessTaskRelationLog::new).collect(Collectors.toMap(ProcessTaskRelation::getPostTaskCode, processTaskRelationLog -> processTaskRelationLog));
        Set postTaskCodesSet = Lists.newArrayList((Object[])postTaskCodes.split(",")).stream().map(Long::parseLong).collect(Collectors.toSet());
        int delete = 0;
        int deleteLog = 0;
        HashSet<Long> processCodeSet = new HashSet<Long>();
        Iterator<Object> iterator = postTaskCodesSet.iterator();
        while (iterator.hasNext()) {
            long postTaskCode = (Long)iterator.next();
            ProcessTaskRelationLog processTaskRelationLog2 = taskRelationLogMap.get(postTaskCode);
            if (processTaskRelationLog2 == null) continue;
            delete += this.processTaskRelationMapper.deleteRelation(processTaskRelationLog2);
            deleteLog += this.processTaskRelationLogMapper.deleteRelation(processTaskRelationLog2);
            processCodeSet.add(processTaskRelationLog2.getProcessDefinitionCode());
        }
        iterator = processCodeSet.iterator();
        while (iterator.hasNext()) {
            long code = (Long)iterator.next();
            ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(code);
            if (processDefinition == null) {
                throw new ServiceException(Status.PROCESS_DEFINE_NOT_EXIST);
            }
            int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.TRUE, Boolean.TRUE);
            if (insertVersion > 0) continue;
            throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
        }
        if (!(delete & deleteLog)) {
            throw new ServiceException(Status.DELETE_TASK_PROCESS_RELATION_ERROR);
        }
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryUpstreamRelation(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryUpstreamByCode(projectCode, taskCode);
        List taskDefinitionLogList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
            Set taskDefinitions = processTaskRelationList.stream().map(processTaskRelation -> {
                TaskDefinition taskDefinition = this.buildTaskDefinition();
                taskDefinition.setProjectCode(processTaskRelation.getProjectCode());
                taskDefinition.setCode(processTaskRelation.getPreTaskCode());
                taskDefinition.setVersion(processTaskRelation.getPreTaskVersion());
                return taskDefinition;
            }).collect(Collectors.toSet());
            taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitions);
        }
        result.put("data", taskDefinitionLogList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryDownstreamRelation(User loginUser, long projectCode, long taskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryDownstreamByCode(projectCode, taskCode);
        List taskDefinitionLogList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)processTaskRelationList)) {
            Set taskDefinitions = processTaskRelationList.stream().map(processTaskRelation -> {
                TaskDefinition taskDefinition = this.buildTaskDefinition();
                taskDefinition.setProjectCode(processTaskRelation.getProjectCode());
                taskDefinition.setCode(processTaskRelation.getPostTaskCode());
                taskDefinition.setVersion(processTaskRelation.getPostTaskVersion());
                return taskDefinition;
            }).collect(Collectors.toSet());
            taskDefinitionLogList = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitions);
        }
        result.put("data", taskDefinitionLogList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Map<String, Object> deleteEdge(User loginUser, long projectCode, long processDefinitionCode, long preTaskCode, long postTaskCode) {
        Project project = this.projectMapper.queryByCode(projectCode);
        Map<String, Object> result = this.projectService.checkProjectAndAuth(loginUser, project, projectCode);
        if (result.get("status") != Status.SUCCESS) {
            return result;
        }
        ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
        if (processDefinition == null) {
            this.putMsg(result, Status.PROCESS_DEFINE_NOT_EXIST, processDefinitionCode);
            return result;
        }
        List processTaskRelationList = this.processTaskRelationMapper.queryByCode(projectCode, processDefinitionCode, preTaskCode, postTaskCode);
        if (CollectionUtils.isEmpty((Collection)processTaskRelationList)) {
            this.putMsg(result, Status.DATA_IS_NULL, "processTaskRelationList");
            return result;
        }
        if (processTaskRelationList.size() > 1) {
            this.putMsg(result, Status.DATA_IS_NOT_VALID, "processTaskRelationList");
            return result;
        }
        ProcessTaskRelation processTaskRelation = (ProcessTaskRelation)processTaskRelationList.get(0);
        int upstreamCount = this.processTaskRelationMapper.countByCode(projectCode, processTaskRelation.getProcessDefinitionCode(), 0L, processTaskRelation.getPostTaskCode());
        if (upstreamCount == 0) {
            this.putMsg(result, Status.DATA_IS_NULL, "upstreamCount");
            return result;
        }
        if (upstreamCount > 1) {
            int delete = this.processTaskRelationMapper.deleteById((Serializable)Integer.valueOf(processTaskRelation.getId()));
            if (delete == 0) {
                this.putMsg(result, Status.DELETE_EDGE_ERROR, new Object[0]);
            }
            return result;
        }
        this.updateProcessDefiniteVersion(loginUser, result, processDefinition);
        processTaskRelation.setProcessDefinitionVersion(processDefinition.getVersion());
        processTaskRelation.setPreTaskVersion(0);
        processTaskRelation.setPreTaskCode(0L);
        Date now = new Date();
        processTaskRelation.setUpdateTime(now);
        int update = this.processTaskRelationMapper.updateById(processTaskRelation);
        processTaskRelation.setId(0);
        ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog(processTaskRelation);
        processTaskRelationLog.setCreateTime(now);
        processTaskRelationLog.setOperator(loginUser.getId());
        processTaskRelationLog.setOperateTime(now);
        int insert = this.processTaskRelationLogMapper.insert((Object)processTaskRelationLog);
        if ((update & insert) == 0) {
            this.putMsg(result, Status.DELETE_EDGE_ERROR, new Object[0]);
            throw new ServiceException(Status.DELETE_EDGE_ERROR);
        }
        return result;
    }

    private TaskDefinition buildTaskDefinition() {
        return new TaskDefinition(){

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof TaskDefinition)) {
                    return false;
                }
                TaskDefinition that = (TaskDefinition)o;
                return this.getCode() == that.getCode() && this.getVersion() == that.getVersion() && this.getProjectCode() == that.getProjectCode();
            }

            public int hashCode() {
                return Objects.hash(this.getCode(), this.getVersion(), this.getProjectCode());
            }
        };
    }

    private Status deleteUpstreamRelation(User loginUser, long projectCode, Long[] preTaskCodes, long taskCode) {
        int n;
        int insert;
        List upstreamList = this.processTaskRelationMapper.queryUpstreamByCodes(projectCode, taskCode, preTaskCodes);
        if (CollectionUtils.isEmpty((Collection)upstreamList)) {
            return Status.SUCCESS;
        }
        ArrayList<ProcessTaskRelationLog> upstreamLogList = new ArrayList<ProcessTaskRelationLog>();
        Date now = new Date();
        for (ProcessTaskRelation processTaskRelation : upstreamList) {
            ProcessTaskRelationLog processTaskRelationLog = new ProcessTaskRelationLog(processTaskRelation);
            processTaskRelationLog.setOperator(loginUser.getId());
            processTaskRelationLog.setOperateTime(now);
            processTaskRelationLog.setUpdateTime(now);
            upstreamLogList.add(processTaskRelationLog);
        }
        Map<Long, List<ProcessTaskRelationLog>> processTaskRelationListGroupByProcessDefinitionCode = upstreamLogList.stream().collect(Collectors.groupingBy(ProcessTaskRelation::getProcessDefinitionCode));
        List countListGroupByProcessDefinitionCode = this.processTaskRelationMapper.countUpstreamByCodeGroupByProcessDefinitionCode(projectCode, processTaskRelationListGroupByProcessDefinitionCode.keySet().toArray(new Long[0]), taskCode);
        ArrayList<Object> deletes = new ArrayList<Object>();
        ArrayList<ProcessTaskRelationLog> updates = new ArrayList<ProcessTaskRelationLog>();
        for (Map codeCountMap : countListGroupByProcessDefinitionCode) {
            long processDefinitionCode = (Long)codeCountMap.get("processDefinitionCode");
            long countValue = (Long)codeCountMap.get("countValue");
            ProcessDefinition processDefinition = this.processDefinitionMapper.queryByCode(processDefinitionCode);
            if (processDefinition == null) {
                return Status.PROCESS_DEFINE_NOT_EXIST;
            }
            int insertVersion = this.processService.saveProcessDefine(loginUser, processDefinition, Boolean.TRUE, Boolean.TRUE);
            if (insertVersion <= 0) {
                throw new ServiceException(Status.UPDATE_PROCESS_DEFINITION_ERROR);
            }
            List<ProcessTaskRelationLog> processTaskRelationLogList = processTaskRelationListGroupByProcessDefinitionCode.get(processDefinitionCode);
            if (countValue <= (long)processTaskRelationLogList.size()) {
                ProcessTaskRelationLog processTaskRelationLog = processTaskRelationLogList.remove(0);
                if (processTaskRelationLog.getPreTaskCode() != 0L) {
                    processTaskRelationLog.setPreTaskCode(0L);
                    processTaskRelationLog.setPreTaskVersion(0);
                }
                processTaskRelationLog.setProcessDefinitionVersion(insertVersion);
                updates.add(processTaskRelationLog);
            }
            if (processTaskRelationLogList.isEmpty()) continue;
            deletes.addAll(processTaskRelationLogList);
        }
        deletes.addAll(updates);
        int delete = 0;
        int deleteLog = 0;
        for (ProcessTaskRelationLog processTaskRelationLog : deletes) {
            delete += this.processTaskRelationMapper.deleteRelation(processTaskRelationLog);
            deleteLog += this.processTaskRelationLogMapper.deleteRelation(processTaskRelationLog);
        }
        if (!(delete & deleteLog)) {
            throw new ServiceException(Status.DELETE_TASK_PROCESS_RELATION_ERROR);
        }
        if (!updates.isEmpty() && ((insert = this.processTaskRelationMapper.batchInsert(updates)) & (n = this.processTaskRelationLogMapper.batchInsert(updates))) == 0) {
            throw new ServiceException(Status.CREATE_PROCESS_TASK_RELATION_ERROR);
        }
        return Status.SUCCESS;
    }
}

