/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ResourcesService;
import org.apache.dolphinscheduler.api.service.UdfFuncService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ProgramType;
import org.apache.dolphinscheduler.common.enums.UdfType;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"RESOURCES_TAG"})
@RestController
@RequestMapping(value={"resources"})
public class ResourcesController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(ResourcesController.class);
    @Autowired
    private ResourcesService resourceService;
    @Autowired
    private UdfFuncService udfFuncService;

    @ApiOperation(value="createDirctory", notes="CREATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="pid", value="RESOURCE_PID", required=true, dataType="Int", example="10"), @ApiImplicitParam(name="currentDir", value="RESOURCE_CURRENTDIR", required=true, dataType="String")})
    @PostMapping(value={"/directory"})
    @ApiException(value=Status.CREATE_RESOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createDirectory(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="description", required=false) String description, @RequestParam(value="pid") int pid, @RequestParam(value="currentDir") String currentDir) {
        return this.resourceService.createDirectory(loginUser, alias, description, type, pid, currentDir);
    }

    @ApiOperation(value="createResource", notes="CREATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile"), @ApiImplicitParam(name="pid", value="RESOURCE_PID", required=true, dataType="Int", example="10"), @ApiImplicitParam(name="currentDir", value="RESOURCE_CURRENTDIR", required=true, dataType="String")})
    @PostMapping
    @ApiException(value=Status.CREATE_RESOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="description", required=false) String description, @RequestParam(value="file") MultipartFile file, @RequestParam(value="pid") int pid, @RequestParam(value="currentDir") String currentDir) {
        return this.resourceService.createResource(loginUser, alias, description, type, file, pid, currentDir);
    }

    @ApiOperation(value="updateResource", notes="UPDATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="name", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="file", value="RESOURCE_FILE", required=true, dataType="MultipartFile")})
    @PutMapping(value={"/{id}"})
    @ApiException(value=Status.UPDATE_RESOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int resourceId, @RequestParam(value="type") ResourceType type, @RequestParam(value="name") String alias, @RequestParam(value="description", required=false) String description, @RequestParam(value="file", required=false) MultipartFile file) {
        return this.resourceService.updateResource(loginUser, resourceId, alias, description, type, file);
    }

    @ApiOperation(value="queryResourceList", notes="QUERY_RESOURCE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType")})
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryResourceList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type) {
        Map<String, Object> result = this.resourceService.queryResourceList(loginUser, type);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryResourceListPaging", notes="QUERY_RESOURCE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="int", example="10"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_PAGING)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryResourceListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="id") int id, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.resourceService.queryResourceListPaging(loginUser, id, type, searchVal, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="deleteResource", notes="DELETE_RESOURCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_RESOURCE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result deleteResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int resourceId) throws Exception {
        return this.resourceService.delete(loginUser, resourceId);
    }

    @ApiOperation(value="verifyResourceName", notes="VERIFY_RESOURCE_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="fullName", value="RESOURCE_FULL_NAME", required=true, dataType="String")})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_RESOURCE_BY_NAME_AND_TYPE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result verifyResourceName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName") String fullName, @RequestParam(value="type") ResourceType type) {
        return this.resourceService.verifyResourceName(fullName, type, loginUser);
    }

    @ApiOperation(value="queryResourceByProgramType", notes="QUERY_RESOURCE_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType")})
    @GetMapping(value={"/query-by-type"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_RESOURCES_LIST_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryResourceJarList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="programType", required=false) ProgramType programType) {
        Map<String, Object> result = this.resourceService.queryResourceByProgramType(loginUser, type, programType);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryResource", notes="QUERY_BY_RESOURCE_NAME")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="fullName", value="RESOURCE_FULL_NAME", required=true, dataType="String"), @ApiImplicitParam(name="id", value="RESOURCE_ID", required=false, dataType="Int", example="10")})
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.RESOURCE_NOT_EXIST)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="fullName", required=false) String fullName, @PathVariable(value="id", required=false) Integer id, @RequestParam(value="type") ResourceType type) {
        return this.resourceService.queryResource(fullName, id, type);
    }

    @ApiOperation(value="viewResource", notes="VIEW_RESOURCE_BY_ID_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="skipLineNum", value="SKIP_LINE_NUM", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="limit", value="LIMIT", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{id}/view"})
    @ApiException(value=Status.VIEW_RESOURCE_FILE_ON_LINE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result viewResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int resourceId, @RequestParam(value="skipLineNum") int skipLineNum, @RequestParam(value="limit") int limit) {
        return this.resourceService.readResource(resourceId, skipLineNum, limit);
    }

    @ApiOperation(value="onlineCreateResource", notes="ONLINE_CREATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="RESOURCE_TYPE", required=true, dataType="ResourceType"), @ApiImplicitParam(name="fileName", value="RESOURCE_NAME", required=true, dataType="String"), @ApiImplicitParam(name="suffix", value="SUFFIX", required=true, dataType="String"), @ApiImplicitParam(name="description", value="RESOURCE_DESC", dataType="String"), @ApiImplicitParam(name="content", value="CONTENT", required=true, dataType="String"), @ApiImplicitParam(name="pid", value="RESOURCE_PID", required=true, dataType="Int", example="10"), @ApiImplicitParam(name="currentDir", value="RESOURCE_CURRENTDIR", required=true, dataType="String")})
    @PostMapping(value={"/online-create"})
    @ApiException(value=Status.CREATE_RESOURCE_FILE_ON_LINE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result onlineCreateResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") ResourceType type, @RequestParam(value="fileName") String fileName, @RequestParam(value="suffix") String fileSuffix, @RequestParam(value="description", required=false) String description, @RequestParam(value="content") String content, @RequestParam(value="pid") int pid, @RequestParam(value="currentDir") String currentDir) {
        if (StringUtils.isEmpty((String)content)) {
            logger.error("resource file contents are not allowed to be empty");
            return this.error(Status.RESOURCE_FILE_IS_EMPTY.getCode(), Status.RESOURCE_FILE_IS_EMPTY.getMsg());
        }
        return this.resourceService.onlineCreateResource(loginUser, type, fileName, fileSuffix, description, content, pid, currentDir);
    }

    @ApiOperation(value="updateResourceContent", notes="UPDATE_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100"), @ApiImplicitParam(name="content", value="CONTENT", required=true, dataType="String")})
    @PutMapping(value={"/{id}/update-content"})
    @ApiException(value=Status.EDIT_RESOURCE_FILE_ON_LINE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateResourceContent(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int resourceId, @RequestParam(value="content") String content) {
        if (StringUtils.isEmpty((String)content)) {
            logger.error("The resource file contents are not allowed to be empty");
            return this.error(Status.RESOURCE_FILE_IS_EMPTY.getCode(), Status.RESOURCE_FILE_IS_EMPTY.getMsg());
        }
        return this.resourceService.updateResourceContent(resourceId, content);
    }

    @ApiOperation(value="downloadResource", notes="DOWNLOAD_RESOURCE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{id}/download"})
    @ResponseBody
    @ApiException(value=Status.DOWNLOAD_RESOURCE_FILE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public ResponseEntity downloadResource(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int resourceId) throws Exception {
        Resource file = this.resourceService.downloadResource(resourceId);
        if (file == null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)Status.RESOURCE_NOT_EXIST.getMsg());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=\"" + file.getFilename() + "\""})).body((Object)file);
    }

    @ApiOperation(value="createUdfFunc", notes="CREATE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType"), @ApiImplicitParam(name="funcName", value="FUNC_NAME", required=true, dataType="String"), @ApiImplicitParam(name="className", value="CLASS_NAME", required=true, dataType="String"), @ApiImplicitParam(name="argTypes", value="ARG_TYPES", dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", dataType="String"), @ApiImplicitParam(name="description", value="UDF_DESC", dataType="String"), @ApiImplicitParam(name="resourceId", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @PostMapping(value={"/{resourceId}/udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_UDF_FUNCTION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result createUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") UdfType type, @RequestParam(value="funcName") String funcName, @RequestParam(value="className") String className, @RequestParam(value="argTypes", required=false) String argTypes, @RequestParam(value="database", required=false) String database, @RequestParam(value="description", required=false) String description, @PathVariable(value="resourceId") int resourceId) {
        return this.udfFuncService.createUdfFunction(loginUser, funcName, className, argTypes, database, description, type, resourceId);
    }

    @ApiOperation(value="viewUIUdfFunction", notes="VIEW_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/{id}/udf-func"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VIEW_UDF_FUNCTION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result viewUIUdfFunction(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        Map<String, Object> map = this.udfFuncService.queryUdfFuncDetail(id);
        return this.returnDataList(map);
    }

    @ApiOperation(value="updateUdfFunc", notes="UPDATE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="UDF_ID", required=true, dataType="Int"), @ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType"), @ApiImplicitParam(name="funcName", value="FUNC_NAME", required=true, dataType="String"), @ApiImplicitParam(name="className", value="CLASS_NAME", required=true, dataType="String"), @ApiImplicitParam(name="argTypes", value="ARG_TYPES", dataType="String"), @ApiImplicitParam(name="database", value="DATABASE_NAME", dataType="String"), @ApiImplicitParam(name="description", value="UDF_DESC", dataType="String"), @ApiImplicitParam(name="resourceId", value="RESOURCE_ID", required=true, dataType="Int", example="100")})
    @PutMapping(value={"/{resourceId}/udf-func/{id}"})
    @ApiException(value=Status.UPDATE_UDF_FUNCTION_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result updateUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int udfFuncId, @RequestParam(value="type") UdfType type, @RequestParam(value="funcName") String funcName, @RequestParam(value="className") String className, @RequestParam(value="argTypes", required=false) String argTypes, @RequestParam(value="database", required=false) String database, @RequestParam(value="description", required=false) String description, @PathVariable(value="resourceId") int resourceId) {
        Map<String, Object> result = this.udfFuncService.updateUdfFunc(udfFuncId, funcName, className, argTypes, database, description, type, resourceId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="queryUdfFuncListPaging", notes="QUERY_UDF_FUNCTION_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchVal", value="SEARCH_VAL", dataType="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="20")})
    @GetMapping(value={"/udf-func"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_UDF_FUNCTION_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<Object> queryUdfFuncListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        result = this.udfFuncService.queryUdfFuncListPaging(loginUser, searchVal, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="queryUdfFuncList", notes="QUERY_UDF_FUNC_LIST_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="UDF_TYPE", required=true, dataType="UdfType")})
    @GetMapping(value={"/udf-func/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_DATASOURCE_BY_TYPE_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<Object> queryUdfFuncList(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="type") UdfType type) {
        Map<String, Object> result = this.udfFuncService.queryUdfFuncList(loginUser, type.ordinal());
        return this.returnDataList(result);
    }

    @ApiOperation(value="verifyUdfFuncName", notes="VERIFY_UDF_FUNCTION_NAME_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="FUNC_NAME", required=true, dataType="String")})
    @GetMapping(value={"/udf-func/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.VERIFY_UDF_FUNCTION_NAME_ERROR)
    @AccessLogAnnotation
    public Result verifyUdfFuncName(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="name") String name) {
        return this.udfFuncService.verifyUdfFuncByName(name);
    }

    @ApiOperation(value="deleteUdfFunc", notes="DELETE_UDF_FUNCTION_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="UDF_FUNC_ID", required=true, dataType="Int", example="100")})
    @DeleteMapping(value={"/udf-func/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_UDF_FUNCTION_ERROR)
    @AccessLogAnnotation
    public Result deleteUdfFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int udfFuncId) {
        return this.udfFuncService.delete(udfFuncId);
    }

    @ApiOperation(value="authorizedFile", notes="AUTHORIZED_FILE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authed-file"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.AUTHORIZED_FILE_RESOURCE_ERROR)
    @AccessLogAnnotation
    public Result authorizedFile(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.resourceService.authorizedFile(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="authorizeResourceTree", notes="AUTHORIZE_RESOURCE_TREE_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authed-resource-tree"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.AUTHORIZE_RESOURCE_TREE)
    @AccessLogAnnotation
    public Result authorizeResourceTree(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.resourceService.authorizeResourceTree(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="unauthUDFFunc", notes="UNAUTHORIZED_UDF_FUNC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/unauth-udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.UNAUTHORIZED_UDF_FUNCTION_ERROR)
    @AccessLogAnnotation
    public Result unauthUDFFunc(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.resourceService.unauthorizedUDFFunction(loginUser, userId);
        return this.returnDataList(result);
    }

    @ApiOperation(value="authUDFFunc", notes="AUTHORIZED_UDF_FUNC_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="USER_ID", required=true, dataType="Int", example="100")})
    @GetMapping(value={"/authed-udf-func"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.AUTHORIZED_UDF_FUNCTION_ERROR)
    @AccessLogAnnotation
    public Result authorizedUDFFunction(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="userId") Integer userId) {
        Map<String, Object> result = this.resourceService.authorizedUDFFunction(loginUser, userId);
        return this.returnDataList(result);
    }
}

