/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.http;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpSender {
    private static final Logger log = LoggerFactory.getLogger(HttpSender.class);
    private static final String URL_SPLICE_CHAR = "?";
    private static final String REQUEST_TYPE_POST = "POST";
    private static final String REQUEST_TYPE_GET = "GET";
    private static final String DEFAULT_CHARSET = "utf-8";
    private final String headerParams;
    private final String bodyParams;
    private final String contentField;
    private final String requestType;
    private String url;
    private HttpRequestBase httpRequest;

    public HttpSender(Map<String, String> paramsMap) {
        this.url = paramsMap.get("url");
        this.headerParams = paramsMap.get("headerParams");
        this.bodyParams = paramsMap.get("bodyParams");
        this.contentField = paramsMap.get("contentField");
        this.requestType = paramsMap.get("requestType");
    }

    public AlertResult send(String msg) {
        AlertResult alertResult = new AlertResult();
        this.createHttpRequest(msg);
        if (this.httpRequest == null) {
            alertResult.setStatus("false");
            alertResult.setMessage("Request types are not supported");
            return alertResult;
        }
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)this.httpRequest);
            HttpEntity entity = response.getEntity();
            String resp = EntityUtils.toString((HttpEntity)entity, (String)DEFAULT_CHARSET);
            alertResult.setStatus("true");
            alertResult.setMessage(resp);
        }
        catch (Exception e) {
            log.error("send http alert msg  exception : {}", (Object)e.getMessage());
            alertResult.setStatus("false");
            alertResult.setMessage("send http request  alert fail.");
        }
        return alertResult;
    }

    private void createHttpRequest(String msg) {
        if (REQUEST_TYPE_POST.equals(this.requestType)) {
            this.httpRequest = new HttpPost(this.url);
            this.setHeader();
            this.setMsgInRequestBody(msg);
        } else if (REQUEST_TYPE_GET.equals(this.requestType)) {
            this.setMsgInUrl(msg);
            this.httpRequest = new HttpGet(this.url);
            this.setHeader();
        }
    }

    private void setMsgInUrl(String msg) {
        if (StringUtils.isNotBlank((CharSequence)this.contentField)) {
            String type = "&";
            if (!this.url.contains(URL_SPLICE_CHAR)) {
                type = URL_SPLICE_CHAR;
            }
            this.url = String.format("%s%s%s=%s", this.url, type, this.contentField, msg);
        }
    }

    private void setHeader() {
        if (this.httpRequest == null) {
            return;
        }
        HashMap map = (HashMap)JSONUtils.parseObject((String)this.headerParams, HashMap.class);
        for (Map.Entry entry : map.entrySet()) {
            this.httpRequest.setHeader((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
    }

    private void setMsgInRequestBody(String msg) {
        ObjectNode objectNode = JSONUtils.parseObject((String)this.bodyParams);
        objectNode.put(this.contentField, msg);
        try {
            StringEntity entity = new StringEntity(this.bodyParams, DEFAULT_CHARSET);
            ((HttpPost)this.httpRequest).setEntity((HttpEntity)entity);
        }
        catch (Exception e) {
            log.error("send http alert msg  exception : {}", (Object)e.getMessage());
        }
    }
}

