/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.io.airlift.slice;

import com.facebook.presto.jdbc.internal.io.airlift.slice.JvmUtils;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Preconditions;
import sun.misc.Unsafe;

public final class ByteArrays {
    private ByteArrays() {
    }

    public static short getShort(byte[] bytes, int index) {
        ByteArrays.checkIndexLength(bytes.length, index, 2);
        return JvmUtils.unsafe.getShort(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static int getInt(byte[] bytes, int index) {
        ByteArrays.checkIndexLength(bytes.length, index, 4);
        return JvmUtils.unsafe.getInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static long getLong(byte[] bytes, int index) {
        ByteArrays.checkIndexLength(bytes.length, index, 8);
        return JvmUtils.unsafe.getLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static float getFloat(byte[] bytes, int index) {
        ByteArrays.checkIndexLength(bytes.length, index, 4);
        return JvmUtils.unsafe.getFloat(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static double getDouble(byte[] bytes, int index) {
        ByteArrays.checkIndexLength(bytes.length, index, 8);
        return JvmUtils.unsafe.getDouble(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index);
    }

    public static void setShort(byte[] bytes, int index, short value) {
        ByteArrays.checkIndexLength(bytes.length, index, 2);
        JvmUtils.unsafe.putShort(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static void setInt(byte[] bytes, int index, int value) {
        ByteArrays.checkIndexLength(bytes.length, index, 4);
        JvmUtils.unsafe.putInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static void setLong(byte[] bytes, int index, long value) {
        ByteArrays.checkIndexLength(bytes.length, index, 8);
        JvmUtils.unsafe.putLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static void setFloat(byte[] bytes, int index, float value) {
        ByteArrays.checkIndexLength(bytes.length, index, 4);
        JvmUtils.unsafe.putFloat(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    public static void setDouble(byte[] bytes, int index, double value) {
        ByteArrays.checkIndexLength(bytes.length, index, 8);
        JvmUtils.unsafe.putDouble(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)index, value);
    }

    private static void checkIndexLength(int arrayLength, int index, int typeLength) {
        Preconditions.checkPositionIndexes(index, index + typeLength, arrayLength);
    }
}

