/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade.shell;

import org.apache.dolphinscheduler.dao.upgrade.DolphinSchedulerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@ComponentScan(value={"org.apache.dolphinscheduler.dao"})
@EnableAutoConfiguration(exclude={QuartzAutoConfiguration.class})
public class UpgradeDolphinScheduler {
    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{UpgradeDolphinScheduler.class}).profiles(new String[]{"shell-upgrade", "shell-cli"}).web(WebApplicationType.NONE).run(args);
    }

    @Component
    @Profile(value={"shell-upgrade"})
    static class UpgradeRunner
    implements CommandLineRunner {
        private static final Logger logger = LoggerFactory.getLogger(UpgradeRunner.class);
        private final DolphinSchedulerManager dolphinSchedulerManager;

        UpgradeRunner(DolphinSchedulerManager dolphinSchedulerManager) {
            this.dolphinSchedulerManager = dolphinSchedulerManager;
        }

        public void run(String ... args) throws Exception {
            this.dolphinSchedulerManager.upgradeDolphinScheduler();
            logger.info("upgrade DolphinScheduler success");
        }
    }
}

