/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskTimeoutStrategy;
import org.apache.dolphinscheduler.common.enums.TimeoutFlag;
import org.apache.dolphinscheduler.common.process.Property;
import org.apache.dolphinscheduler.common.utils.JSONUtils;

@TableName(value="t_ds_task_definition")
public class TaskDefinition {
    @TableId(value="id", type=IdType.AUTO)
    private int id;
    private long code;
    private String name;
    private int version;
    private String description;
    private long projectCode;
    private int userId;
    private String taskType;
    @JsonDeserialize(using=JSONUtils.JsonDataDeserializer.class)
    @JsonSerialize(using=JSONUtils.JsonDataSerializer.class)
    private String taskParams;
    @TableField(exist=false)
    private List<Property> taskParamList;
    @TableField(exist=false)
    private Map<String, String> taskParamMap;
    private Flag flag;
    private Priority taskPriority;
    @TableField(exist=false)
    private String userName;
    @TableField(exist=false)
    private String projectName;
    private String workerGroup;
    private long environmentCode;
    private int failRetryTimes;
    private int failRetryInterval;
    private TimeoutFlag timeoutFlag;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private TaskTimeoutStrategy timeoutNotifyStrategy;
    private int timeout;
    private int delayTime;
    private String resourceIds;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;
    @TableField(exist=false)
    private String modifyBy;

    public TaskDefinition() {
    }

    public TaskDefinition(long code, int version) {
        this.code = code;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTaskParams() {
        return this.taskParams;
    }

    public void setTaskParams(String taskParams) {
        this.taskParams = taskParams;
    }

    public List<Property> getTaskParamList() {
        JsonNode localParams = JSONUtils.parseObject((String)this.taskParams).findValue("localParams");
        if (localParams != null) {
            this.taskParamList = JSONUtils.toList((String)localParams.toString(), Property.class);
        }
        return this.taskParamList;
    }

    public void setTaskParamList(List<Property> taskParamList) {
        this.taskParamList = taskParamList;
    }

    public void setTaskParamMap(Map<String, String> taskParamMap) {
        this.taskParamMap = taskParamMap;
    }

    public Map<String, String> getTaskParamMap() {
        JsonNode localParams;
        if (this.taskParamMap == null && StringUtils.isNotEmpty((CharSequence)this.taskParams) && (localParams = JSONUtils.parseObject((String)this.taskParams).findValue("localParams")) != null) {
            List propList = JSONUtils.toList((String)localParams.toString(), Property.class);
            this.taskParamMap = propList.stream().collect(Collectors.toMap(Property::getProp, Property::getValue));
        }
        return this.taskParamMap;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public Priority getTaskPriority() {
        return this.taskPriority;
    }

    public void setTaskPriority(Priority taskPriority) {
        this.taskPriority = taskPriority;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public int getFailRetryTimes() {
        return this.failRetryTimes;
    }

    public void setFailRetryTimes(int failRetryTimes) {
        this.failRetryTimes = failRetryTimes;
    }

    public int getFailRetryInterval() {
        return this.failRetryInterval;
    }

    public void setFailRetryInterval(int failRetryInterval) {
        this.failRetryInterval = failRetryInterval;
    }

    public TaskTimeoutStrategy getTimeoutNotifyStrategy() {
        return this.timeoutNotifyStrategy;
    }

    public void setTimeoutNotifyStrategy(TaskTimeoutStrategy timeoutNotifyStrategy) {
        this.timeoutNotifyStrategy = timeoutNotifyStrategy;
    }

    public TimeoutFlag getTimeoutFlag() {
        return this.timeoutFlag;
    }

    public void setTimeoutFlag(TimeoutFlag timeoutFlag) {
        this.timeoutFlag = timeoutFlag;
    }

    public String getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(String resourceIds) {
        this.resourceIds = resourceIds;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public String getDependence() {
        return JSONUtils.getNodeString((String)this.taskParams, (String)"dependence");
    }

    public String getModifyBy() {
        return this.modifyBy;
    }

    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    public long getEnvironmentCode() {
        return this.environmentCode;
    }

    public void setEnvironmentCode(long environmentCode) {
        this.environmentCode = environmentCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        TaskDefinition that = (TaskDefinition)o;
        return this.failRetryTimes == that.failRetryTimes && this.failRetryInterval == that.failRetryInterval && this.timeout == that.timeout && this.delayTime == that.delayTime && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.taskType, that.taskType) && Objects.equals(this.taskParams, that.taskParams) && this.flag == that.flag && this.taskPriority == that.taskPriority && Objects.equals(this.workerGroup, that.workerGroup) && this.timeoutFlag == that.timeoutFlag && this.timeoutNotifyStrategy == that.timeoutNotifyStrategy && Objects.equals(this.resourceIds, that.resourceIds) && this.environmentCode == that.environmentCode;
    }

    public String toString() {
        return "TaskDefinition{id=" + this.id + ", code=" + this.code + ", name='" + this.name + '\'' + ", version=" + this.version + ", description='" + this.description + '\'' + ", projectCode=" + this.projectCode + ", userId=" + this.userId + ", taskType=" + this.taskType + ", taskParams='" + this.taskParams + '\'' + ", taskParamList=" + this.taskParamList + ", taskParamMap=" + this.taskParamMap + ", flag=" + this.flag + ", taskPriority=" + this.taskPriority + ", userName='" + this.userName + '\'' + ", projectName='" + this.projectName + '\'' + ", workerGroup='" + this.workerGroup + '\'' + ", failRetryTimes=" + this.failRetryTimes + ", environmentCode='" + this.environmentCode + '\'' + ", failRetryInterval=" + this.failRetryInterval + ", timeoutFlag=" + this.timeoutFlag + ", timeoutNotifyStrategy=" + this.timeoutNotifyStrategy + ", timeout=" + this.timeout + ", delayTime=" + this.delayTime + ", resourceIds='" + this.resourceIds + '\'' + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + '}';
    }
}

