/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.alert;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.ProcessAlertContent;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ProjectUser;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessAlertManager {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAlertManager.class);
    @Autowired
    private AlertDao alertDao;

    private String getCommandCnName(CommandType commandType) {
        switch (commandType) {
            case RECOVER_TOLERANCE_FAULT_PROCESS: {
                return "recover tolerance fault process";
            }
            case RECOVER_SUSPENDED_PROCESS: {
                return "recover suspended process";
            }
            case START_CURRENT_TASK_PROCESS: {
                return "start current task process";
            }
            case START_FAILURE_TASK_PROCESS: {
                return "start failure task process";
            }
            case START_PROCESS: {
                return "start process";
            }
            case REPEAT_RUNNING: {
                return "repeat running";
            }
            case SCHEDULER: {
                return "scheduler";
            }
            case COMPLEMENT_DATA: {
                return "complement data";
            }
            case PAUSE: {
                return "pause";
            }
            case STOP: {
                return "stop";
            }
        }
        return "unknown type";
    }

    public String getContentProcessInstance(ProcessInstance processInstance, List<TaskInstance> taskInstances, ProjectUser projectUser) {
        String res = "";
        if (processInstance.getState().typeIsSuccess()) {
            ArrayList<ProcessAlertContent> successTaskList = new ArrayList<ProcessAlertContent>(1);
            ProcessAlertContent processAlertContent = ProcessAlertContent.newBuilder().projectId(Integer.valueOf(projectUser.getProjectId())).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).processId(Integer.valueOf(processInstance.getId())).processDefinitionCode(processInstance.getProcessDefinitionCode()).processName(processInstance.getName()).processType(processInstance.getCommandType()).processState(processInstance.getState()).recovery(processInstance.getRecovery()).runTimes(Integer.valueOf(processInstance.getRunTimes())).processStartTime(processInstance.getStartTime()).processEndTime(processInstance.getEndTime()).processHost(processInstance.getHost()).build();
            successTaskList.add(processAlertContent);
            res = JSONUtils.toJsonString(successTaskList);
        } else if (processInstance.getState().typeIsFailure()) {
            ArrayList<ProcessAlertContent> failedTaskList = new ArrayList<ProcessAlertContent>();
            for (TaskInstance task : taskInstances) {
                if (task.getState().typeIsSuccess()) continue;
                ProcessAlertContent processAlertContent = ProcessAlertContent.newBuilder().projectId(Integer.valueOf(projectUser.getProjectId())).projectName(projectUser.getProjectName()).owner(projectUser.getUserName()).processId(Integer.valueOf(processInstance.getId())).processDefinitionCode(processInstance.getProcessDefinitionCode()).processName(processInstance.getName()).taskCode(Long.valueOf(task.getTaskCode())).taskName(task.getName()).taskType(task.getTaskType()).taskState(task.getState()).taskStartTime(task.getStartTime()).taskEndTime(task.getEndTime()).taskHost(task.getHost()).logPath(task.getLogPath()).build();
                failedTaskList.add(processAlertContent);
            }
            res = JSONUtils.toJsonString(failedTaskList);
        }
        return res;
    }

    private String getWorkerToleranceContent(ProcessInstance processInstance, List<TaskInstance> toleranceTaskList) {
        ArrayList<ProcessAlertContent> toleranceTaskInstanceList = new ArrayList<ProcessAlertContent>();
        for (TaskInstance taskInstance : toleranceTaskList) {
            ProcessAlertContent processAlertContent = ProcessAlertContent.newBuilder().processId(Integer.valueOf(processInstance.getId())).processDefinitionCode(processInstance.getProcessDefinitionCode()).processName(processInstance.getName()).taskCode(Long.valueOf(taskInstance.getTaskCode())).taskName(taskInstance.getName()).taskHost(taskInstance.getHost()).retryTimes(Integer.valueOf(taskInstance.getRetryTimes())).build();
            toleranceTaskInstanceList.add(processAlertContent);
        }
        return JSONUtils.toJsonString(toleranceTaskInstanceList);
    }

    public void sendAlertWorkerToleranceFault(ProcessInstance processInstance, List<TaskInstance> toleranceTaskList) {
        try {
            Alert alert = new Alert();
            alert.setTitle("worker fault tolerance");
            String content = this.getWorkerToleranceContent(processInstance, toleranceTaskList);
            alert.setContent(content);
            alert.setCreateTime(new Date());
            alert.setAlertGroupId(processInstance.getWarningGroupId() == null ? 1 : processInstance.getWarningGroupId());
            this.alertDao.addAlert(alert);
            logger.info("add alert to db , alert : {}", (Object)alert);
        }
        catch (Exception e) {
            logger.error("send alert failed:{} ", (Object)e.getMessage());
        }
    }

    public void sendAlertProcessInstance(ProcessInstance processInstance, List<TaskInstance> taskInstances, ProjectUser projectUser) {
        if (Flag.YES == processInstance.getIsSubProcess()) {
            return;
        }
        boolean sendWarnning = false;
        WarningType warningType = processInstance.getWarningType();
        switch (warningType) {
            case ALL: {
                if (!processInstance.getState().typeIsFinished()) break;
                sendWarnning = true;
                break;
            }
            case SUCCESS: {
                if (!processInstance.getState().typeIsSuccess()) break;
                sendWarnning = true;
                break;
            }
            case FAILURE: {
                if (!processInstance.getState().typeIsFailure()) break;
                sendWarnning = true;
                break;
            }
        }
        if (!sendWarnning) {
            return;
        }
        Alert alert = new Alert();
        String cmdName = this.getCommandCnName(processInstance.getCommandType());
        String success = processInstance.getState().typeIsSuccess() ? "success" : "failed";
        alert.setTitle(cmdName + " " + success);
        String content = this.getContentProcessInstance(processInstance, taskInstances, projectUser);
        alert.setContent(content);
        alert.setAlertGroupId(processInstance.getWarningGroupId().intValue());
        alert.setCreateTime(new Date());
        this.alertDao.addAlert(alert);
        logger.info("add alert to db , alert: {}", (Object)alert);
    }

    public void sendProcessTimeoutAlert(ProcessInstance processInstance, ProcessDefinition processDefinition) {
        this.alertDao.sendProcessTimeoutAlert(processInstance, processDefinition);
    }

    public void sendTaskTimeoutAlert(ProcessInstance processInstance, TaskInstance taskInstance, TaskDefinition taskDefinition) {
        this.alertDao.sendTaskTimeoutAlert(processInstance, taskInstance, taskDefinition);
    }
}

