/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sqoop;

import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.sqoop.generator.SqoopJobGenerator;
import org.apache.dolphinscheduler.plugin.task.sqoop.parameter.SqoopParameters;
import org.apache.dolphinscheduler.plugin.task.util.MapUtils;
import org.apache.dolphinscheduler.spi.task.AbstractParameters;
import org.apache.dolphinscheduler.spi.task.paramparser.ParamUtils;
import org.apache.dolphinscheduler.spi.task.paramparser.ParameterUtils;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;

public class SqoopTask
extends AbstractYarnTask {
    private SqoopParameters sqoopParameters;
    private final TaskRequest taskExecutionContext;

    public SqoopTask(TaskRequest taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.logger.info("sqoop task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.sqoopParameters = (SqoopParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), SqoopParameters.class));
        if (null == this.sqoopParameters) {
            throw new IllegalArgumentException("Sqoop Task params is null");
        }
        if (!this.sqoopParameters.checkParameters()) {
            throw new IllegalArgumentException("Sqoop Task params check fail");
        }
    }

    protected String buildCommand() {
        SqoopJobGenerator generator = new SqoopJobGenerator();
        String script = generator.generateSqoopJob(this.sqoopParameters, this.taskExecutionContext);
        HashMap paramsMap = ParamUtils.convert((TaskRequest)this.taskExecutionContext, (AbstractParameters)this.getParameters());
        if (MapUtils.isEmpty((Map)paramsMap)) {
            paramsMap = new HashMap();
        }
        if (MapUtils.isNotEmpty((Map)this.taskExecutionContext.getParamsMap())) {
            paramsMap.putAll(this.taskExecutionContext.getParamsMap());
        }
        String resultScripts = ParameterUtils.convertParameterPlaceholders((String)script, (Map)ParamUtils.convert(paramsMap));
        this.logger.info("sqoop script: {}", (Object)resultScripts);
        return resultScripts;
    }

    protected void setMainJarName() {
    }

    public AbstractParameters getParameters() {
        return this.sqoopParameters;
    }
}

