/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.curator.shaded.com.google.common.collect.Sets;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.service.WorkFlowLineageService;
import org.apache.dolphinscheduler.api.service.impl.BaseServiceImpl;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.model.DependentItem;
import org.apache.dolphinscheduler.common.model.DependentTaskModel;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessLineage;
import org.apache.dolphinscheduler.dao.entity.Project;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;
import org.apache.dolphinscheduler.dao.entity.TaskDefinitionLog;
import org.apache.dolphinscheduler.dao.entity.WorkFlowLineage;
import org.apache.dolphinscheduler.dao.entity.WorkFlowRelation;
import org.apache.dolphinscheduler.dao.mapper.ProjectMapper;
import org.apache.dolphinscheduler.dao.mapper.TaskDefinitionLogMapper;
import org.apache.dolphinscheduler.dao.mapper.WorkFlowLineageMapper;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowLineageServiceImpl
extends BaseServiceImpl
implements WorkFlowLineageService {
    @Autowired
    private WorkFlowLineageMapper workFlowLineageMapper;
    @Autowired
    private ProjectMapper projectMapper;
    @Autowired
    private TaskDefinitionLogMapper taskDefinitionLogMapper;

    @Override
    public Map<String, Object> queryWorkFlowLineageByName(long projectCode, String workFlowName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, projectCode);
            return result;
        }
        List workFlowLineageList = this.workFlowLineageMapper.queryWorkFlowLineageByName(projectCode, workFlowName);
        result.put("data", workFlowLineageList);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    @Override
    public Map<String, Object> queryWorkFlowLineageByCode(long projectCode, long workFlowCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, projectCode);
            return result;
        }
        HashMap<Long, WorkFlowLineage> workFlowLineagesMap = new HashMap<Long, WorkFlowLineage>();
        HashSet<WorkFlowRelation> workFlowRelations = new HashSet<WorkFlowRelation>();
        HashSet sourceWorkFlowCodes = Sets.newHashSet((Object[])new Long[]{workFlowCode});
        this.recursiveWorkFlow(projectCode, workFlowLineagesMap, workFlowRelations, sourceWorkFlowCodes);
        HashMap<String, Collection<Object>> workFlowLists = new HashMap<String, Collection<Object>>();
        workFlowLists.put("workFlowList", workFlowLineagesMap.values());
        workFlowLists.put("workFlowRelationList", workFlowRelations);
        result.put("data", workFlowLists);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private void recursiveWorkFlow(long projectCode, Map<Long, WorkFlowLineage> workFlowLineagesMap, Set<WorkFlowRelation> workFlowRelations, Set<Long> sourceWorkFlowCodes) {
        for (Long workFlowCode : sourceWorkFlowCodes) {
            WorkFlowLineage workFlowLineage = this.workFlowLineageMapper.queryWorkFlowLineageByCode(projectCode, workFlowCode.longValue());
            workFlowLineagesMap.put(workFlowCode, workFlowLineage);
            List processLineages = this.workFlowLineageMapper.queryProcessLineageByCode(projectCode, workFlowCode.longValue());
            ArrayList<TaskDefinition> taskDefinitionList = new ArrayList<TaskDefinition>();
            for (ProcessLineage processLineage : processLineages) {
                if (processLineage.getPreTaskCode() > 0L) {
                    taskDefinitionList.add(new TaskDefinition(processLineage.getPreTaskCode(), processLineage.getPreTaskVersion()));
                }
                if (processLineage.getPostTaskCode() <= 0L) continue;
                taskDefinitionList.add(new TaskDefinition(processLineage.getPostTaskCode(), processLineage.getPostTaskVersion()));
            }
            sourceWorkFlowCodes = this.querySourceWorkFlowCodes(projectCode, workFlowCode, taskDefinitionList);
            if (sourceWorkFlowCodes.isEmpty()) {
                workFlowRelations.add(new WorkFlowRelation(0L, workFlowCode.longValue()));
                return;
            }
            workFlowLineagesMap.get(workFlowCode).setSourceWorkFlowCode(StringUtils.join(sourceWorkFlowCodes, (String)","));
            sourceWorkFlowCodes.forEach(code -> workFlowRelations.add(new WorkFlowRelation(code.longValue(), workFlowCode.longValue())));
            this.recursiveWorkFlow(projectCode, workFlowLineagesMap, workFlowRelations, sourceWorkFlowCodes);
        }
    }

    @Override
    public Map<String, Object> queryWorkFlowLineage(long projectCode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Project project = this.projectMapper.queryByCode(projectCode);
        if (project == null) {
            this.putMsg(result, Status.PROJECT_NOT_FOUNT, projectCode);
            return result;
        }
        List processLineages = this.workFlowLineageMapper.queryProcessLineage(projectCode);
        Map<Object, Object> workFlowLineagesMap = new HashMap();
        HashSet<WorkFlowRelation> workFlowRelations = new HashSet<WorkFlowRelation>();
        if (!processLineages.isEmpty()) {
            List workFlowLineages = this.workFlowLineageMapper.queryWorkFlowLineageByLineage(processLineages);
            workFlowLineagesMap = workFlowLineages.stream().collect(Collectors.toMap(WorkFlowLineage::getWorkFlowCode, workFlowLineage -> workFlowLineage));
            HashMap<Long, List> workFlowMap = new HashMap<Long, List>();
            for (ProcessLineage processLineage : processLineages) {
                workFlowMap.compute(processLineage.getProcessDefinitionCode(), (k, v) -> {
                    if (v == null) {
                        v = new ArrayList<TaskDefinition>();
                    }
                    if (processLineage.getPreTaskCode() > 0L) {
                        v.add(new TaskDefinition(processLineage.getPreTaskCode(), processLineage.getPreTaskVersion()));
                    }
                    if (processLineage.getPostTaskCode() > 0L) {
                        v.add(new TaskDefinition(processLineage.getPostTaskCode(), processLineage.getPostTaskVersion()));
                    }
                    return v;
                });
            }
            for (Map.Entry entry : workFlowMap.entrySet()) {
                Set<Long> sourceWorkFlowCodes = this.querySourceWorkFlowCodes(projectCode, (Long)entry.getKey(), (List)entry.getValue());
                if (sourceWorkFlowCodes.isEmpty()) {
                    workFlowRelations.add(new WorkFlowRelation(0L, ((Long)entry.getKey()).longValue()));
                    continue;
                }
                ((WorkFlowLineage)workFlowLineagesMap.get(entry.getKey())).setSourceWorkFlowCode(StringUtils.join(sourceWorkFlowCodes, (String)","));
                sourceWorkFlowCodes.forEach(code -> workFlowRelations.add(new WorkFlowRelation(code.longValue(), ((Long)workFlow.getKey()).longValue())));
            }
        }
        HashMap<String, Collection<Object>> workFlowLists = new HashMap<String, Collection<Object>>();
        workFlowLists.put("workFlowList", workFlowLineagesMap.values());
        workFlowLists.put("workFlowRelationList", workFlowRelations);
        result.put("data", workFlowLists);
        this.putMsg(result, Status.SUCCESS, new Object[0]);
        return result;
    }

    private Set<Long> querySourceWorkFlowCodes(long projectCode, long workFlowCode, List<TaskDefinition> taskDefinitionList) {
        HashSet<Long> sourceWorkFlowCodes = new HashSet<Long>();
        if (taskDefinitionList == null || taskDefinitionList.isEmpty()) {
            return sourceWorkFlowCodes;
        }
        List taskDefinitionLogs = this.taskDefinitionLogMapper.queryByTaskDefinitions(taskDefinitionList);
        for (TaskDefinitionLog taskDefinitionLog : taskDefinitionLogs) {
            DependentParameters dependentParameters;
            if (taskDefinitionLog.getProjectCode() != projectCode || !taskDefinitionLog.getTaskType().equals(TaskType.DEPENDENT.getDesc()) || (dependentParameters = (DependentParameters)JSONUtils.parseObject((String)taskDefinitionLog.getDependence(), DependentParameters.class)) == null) continue;
            List dependTaskList = dependentParameters.getDependTaskList();
            for (DependentTaskModel taskModel : dependTaskList) {
                List dependItemList = taskModel.getDependItemList();
                for (DependentItem dependentItem : dependItemList) {
                    if (dependentItem.getProjectCode() != projectCode || dependentItem.getDefinitionCode() == workFlowCode) continue;
                    sourceWorkFlowCodes.add(dependentItem.getDefinitionCode());
                }
            }
        }
        return sourceWorkFlowCodes;
    }
}

