/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.registry;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.enums.NodeType;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.registry.api.ConnectionState;
import org.apache.dolphinscheduler.remote.utils.NamedThreadFactory;
import org.apache.dolphinscheduler.server.registry.HeartBeatTask;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.service.registry.RegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkerRegistryClient {
    private final Logger logger = LoggerFactory.getLogger(WorkerRegistryClient.class);
    @Autowired
    private WorkerConfig workerConfig;
    @Autowired
    private WorkerManagerThread workerManagerThread;
    private ScheduledExecutorService heartBeatExecutor;
    @Autowired
    private RegistryClient registryClient;
    private long startupTime;
    private Set<String> workerGroups;

    @PostConstruct
    public void initWorkRegistry() {
        this.workerGroups = this.workerConfig.getWorkerGroups();
        this.startupTime = System.currentTimeMillis();
        this.heartBeatExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("HeartBeatExecutor"));
    }

    public void registry() {
        String address = NetUtils.getAddr((int)this.workerConfig.getListenPort());
        Set<String> workerZkPaths = this.getWorkerZkPaths();
        int workerHeartbeatInterval = this.workerConfig.getWorkerHeartbeatInterval();
        HeartBeatTask heartBeatTask = new HeartBeatTask(this.startupTime, this.workerConfig.getWorkerMaxCpuloadAvg(), this.workerConfig.getWorkerReservedMemory(), this.workerConfig.getHostWeight(), workerZkPaths, "worker", this.registryClient, this.workerConfig.getWorkerExecThreads(), this.workerManagerThread);
        for (String workerZKPath : workerZkPaths) {
            this.registryClient.remove(workerZKPath);
            this.registryClient.persistEphemeral(workerZKPath, heartBeatTask.getHeartBeatInfo());
            this.logger.info("worker node : {} registry to ZK {} successfully", (Object)address, (Object)workerZKPath);
        }
        while (!this.checkNodeExists()) {
            ThreadUtils.sleep((long)1000L);
        }
        ThreadUtils.sleep((long)1000L);
        this.handleDeadServer(workerZkPaths, NodeType.WORKER, "delete");
        this.registryClient.addConnectionStateListener(this::handleConnectionState);
        this.heartBeatExecutor.scheduleAtFixedRate(heartBeatTask, workerHeartbeatInterval, workerHeartbeatInterval, TimeUnit.SECONDS);
        this.logger.info("worker node : {} heartbeat interval {} s", (Object)address, (Object)workerHeartbeatInterval);
    }

    public void handleConnectionState(ConnectionState state) {
        switch (state) {
            case CONNECTED: {
                this.logger.debug("registry connection state is {}", (Object)state);
                break;
            }
            case SUSPENDED: {
                this.logger.warn("registry connection state is {}, ready to retry connection", (Object)state);
                break;
            }
            case RECONNECTED: {
                this.logger.debug("registry connection state is {}, clean the node info", (Object)state);
                String address = NetUtils.getAddr((int)this.workerConfig.getListenPort());
                Set<String> workerZkPaths = this.getWorkerZkPaths();
                for (String workerZKPath : workerZkPaths) {
                    this.registryClient.persistEphemeral(workerZKPath, "");
                    this.logger.info("worker node : {} reconnect to ZK {} successfully", (Object)address, (Object)workerZKPath);
                }
                break;
            }
            case DISCONNECTED: {
                this.logger.warn("registry connection state is {}, ready to stop myself", (Object)state);
                this.registryClient.getStoppable().stop("registry connection state is DISCONNECTED, stop myself");
                break;
            }
        }
    }

    public void unRegistry() throws IOException {
        try {
            String address = this.getLocalAddress();
            Set<String> workerZkPaths = this.getWorkerZkPaths();
            for (String workerZkPath : workerZkPaths) {
                this.registryClient.remove(workerZkPath);
                this.logger.info("worker node : {} unRegistry from ZK {}.", (Object)address, (Object)workerZkPath);
            }
        }
        catch (Exception ex) {
            this.logger.error("remove worker zk path exception", (Throwable)ex);
        }
        this.heartBeatExecutor.shutdownNow();
        this.logger.info("heartbeat executor shutdown");
        this.registryClient.close();
        this.logger.info("registry client closed");
    }

    public Set<String> getWorkerZkPaths() {
        HashSet workerPaths = Sets.newHashSet();
        String address = this.getLocalAddress();
        for (String workGroup : this.workerGroups) {
            StringJoiner workerPathJoiner = new StringJoiner("/");
            workerPathJoiner.add("/nodes/worker");
            if (StringUtils.isEmpty((String)workGroup)) {
                workGroup = "default";
            }
            workerPathJoiner.add(workGroup.trim().toLowerCase());
            workerPathJoiner.add(address);
            workerPaths.add(workerPathJoiner.toString());
        }
        return workerPaths;
    }

    public void handleDeadServer(Set<String> nodeSet, NodeType nodeType, String opType) {
        this.registryClient.handleDeadServer(nodeSet, nodeType, opType);
    }

    private String getLocalAddress() {
        return NetUtils.getAddr((int)this.workerConfig.getListenPort());
    }

    public void setRegistryStoppable(IStoppable stoppable) {
        this.registryClient.setStoppable(stoppable);
    }

    public boolean checkNodeExists() {
        boolean result = this.registryClient.checkNodeExists(NetUtils.getHost(), NodeType.WORKER);
        if (result) {
            this.logger.info("check worker, node exist success, host:{}", (Object)NetUtils.getHost());
        }
        return result;
    }
}

