/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.worker.processor;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.LoggerUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.remote.command.Command;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.command.TaskKillRequestCommand;
import org.apache.dolphinscheduler.remote.command.TaskKillResponseCommand;
import org.apache.dolphinscheduler.remote.processor.NettyRemoteChannel;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.apache.dolphinscheduler.remote.utils.Host;
import org.apache.dolphinscheduler.remote.utils.Pair;
import org.apache.dolphinscheduler.server.utils.ProcessUtils;
import org.apache.dolphinscheduler.server.worker.config.WorkerConfig;
import org.apache.dolphinscheduler.server.worker.processor.TaskCallbackService;
import org.apache.dolphinscheduler.server.worker.runner.WorkerManagerThread;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.apache.dolphinscheduler.service.log.LogClientService;
import org.apache.dolphinscheduler.service.queue.entity.TaskExecutionContext;
import org.apache.dolphinscheduler.spi.task.TaskExecutionContextCacheManager;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskKillProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(TaskKillProcessor.class);
    private final WorkerConfig workerConfig;
    private final TaskCallbackService taskCallbackService = (TaskCallbackService)SpringApplicationContext.getBean(TaskCallbackService.class);
    private final WorkerManagerThread workerManager;

    public TaskKillProcessor() {
        this.workerConfig = (WorkerConfig)SpringApplicationContext.getBean(WorkerConfig.class);
        this.workerManager = (WorkerManagerThread)SpringApplicationContext.getBean(WorkerManagerThread.class);
    }

    public void process(Channel channel, Command command) {
        Preconditions.checkArgument((CommandType.TASK_KILL_REQUEST == command.getType() ? 1 : 0) != 0, (Object)String.format("invalid command type : %s", command.getType()));
        TaskKillRequestCommand killCommand = (TaskKillRequestCommand)JSONUtils.parseObject((byte[])command.getBody(), TaskKillRequestCommand.class);
        this.logger.info("received kill command : {}", (Object)killCommand);
        Pair<Boolean, List<String>> result = this.doKill(killCommand);
        this.taskCallbackService.addRemoteChannel(killCommand.getTaskInstanceId(), new NettyRemoteChannel(channel, command.getOpaque()));
        TaskKillResponseCommand taskKillResponseCommand = this.buildKillTaskResponseCommand(killCommand, result);
        this.taskCallbackService.sendResult(taskKillResponseCommand.getTaskInstanceId(), taskKillResponseCommand.convert2Command());
        TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)taskKillResponseCommand.getTaskInstanceId());
        TaskCallbackService.remove(killCommand.getTaskInstanceId());
        this.logger.info("remove REMOTE_CHANNELS, task instance id:{}", (Object)killCommand.getTaskInstanceId());
    }

    private Pair<Boolean, List<String>> doKill(TaskKillRequestCommand killCommand) {
        boolean processFlag = true;
        List appIds = Collections.emptyList();
        int taskInstanceId = killCommand.getTaskInstanceId();
        TaskRequest taskRequest = TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)taskInstanceId);
        TaskExecutionContext taskExecutionContext = (TaskExecutionContext)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)taskRequest), TaskExecutionContext.class);
        try {
            Integer processId = taskExecutionContext.getProcessId();
            if (processId.equals(0)) {
                this.workerManager.killTaskBeforeExecuteByInstanceId(taskInstanceId);
                TaskExecutionContextCacheManager.removeByTaskInstanceId((Integer)taskInstanceId);
                this.logger.info("the task has not been executed and has been cancelled, task id:{}", (Object)taskInstanceId);
                return Pair.of((Object)true, appIds);
            }
            String pidsStr = ProcessUtils.getPidsStr(taskExecutionContext.getProcessId());
            if (!StringUtils.isEmpty((String)pidsStr)) {
                String cmd = String.format("kill -9 %s", pidsStr);
                cmd = OSUtils.getSudoCmd((String)taskExecutionContext.getTenantCode(), (String)cmd);
                this.logger.info("process id:{}, cmd:{}", (Object)taskExecutionContext.getProcessId(), (Object)cmd);
                OSUtils.exeCmd((String)cmd);
            }
        }
        catch (Exception e) {
            processFlag = false;
            this.logger.error("kill task error", (Throwable)e);
        }
        Pair<Boolean, List<String>> yarnResult = this.killYarnJob(Host.of((String)taskExecutionContext.getHost()).getIp(), taskExecutionContext.getLogPath(), taskExecutionContext.getExecutePath(), taskExecutionContext.getTenantCode());
        return Pair.of((Object)(processFlag && (Boolean)yarnResult.getLeft() != false ? 1 : 0), (Object)yarnResult.getRight());
    }

    private TaskKillResponseCommand buildKillTaskResponseCommand(TaskKillRequestCommand killCommand, Pair<Boolean, List<String>> result) {
        TaskKillResponseCommand taskKillResponseCommand = new TaskKillResponseCommand();
        taskKillResponseCommand.setStatus((Boolean)result.getLeft() != false ? ExecutionStatus.SUCCESS.getCode() : ExecutionStatus.FAILURE.getCode());
        taskKillResponseCommand.setAppIds((List)result.getRight());
        TaskRequest taskRequest = TaskExecutionContextCacheManager.getByTaskInstanceId((Integer)killCommand.getTaskInstanceId());
        if (taskRequest == null) {
            return taskKillResponseCommand;
        }
        TaskExecutionContext taskExecutionContext = (TaskExecutionContext)JSONUtils.parseObject((String)JSONUtils.toJsonString((Object)taskRequest), TaskExecutionContext.class);
        if (taskExecutionContext != null) {
            taskKillResponseCommand.setTaskInstanceId(taskExecutionContext.getTaskInstanceId());
            taskKillResponseCommand.setHost(taskExecutionContext.getHost());
            taskKillResponseCommand.setProcessId(taskExecutionContext.getProcessId());
        }
        return taskKillResponseCommand;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Pair<Boolean, List<String>> killYarnJob(String host, String logPath, String executePath, String tenantCode) {
        try (LogClientService logClient = new LogClientService();){
            this.logger.info("view log host : {},logPath : {}", (Object)host, (Object)logPath);
            String log = logClient.viewLog(host, 50051, logPath);
            List appIds = Collections.emptyList();
            if (!StringUtils.isEmpty((String)log)) {
                appIds = LoggerUtils.getAppIds((String)log, (Logger)this.logger);
                if (StringUtils.isEmpty((String)executePath)) {
                    this.logger.error("task instance execute path is empty");
                    throw new RuntimeException("task instance execute path is empty");
                }
                if (appIds.size() > 0) {
                    ProcessUtils.cancelApplication(appIds, this.logger, tenantCode, executePath);
                }
            }
            Pair pair = Pair.of((Object)true, appIds);
            return pair;
        }
        catch (Exception e) {
            this.logger.error("kill yarn job error", (Throwable)e);
            return Pair.of((Object)false, Collections.emptyList());
        }
    }
}

