/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.common.utils.NetUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.dao.entity.Command;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.remote.NettyRemotingClient;
import org.apache.dolphinscheduler.remote.config.NettyClientConfig;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.apache.dolphinscheduler.server.master.dispatch.executor.NettyExecutorManager;
import org.apache.dolphinscheduler.server.master.registry.MasterRegistryClient;
import org.apache.dolphinscheduler.server.master.registry.ServerNodeManager;
import org.apache.dolphinscheduler.server.master.runner.StateWheelExecuteThread;
import org.apache.dolphinscheduler.server.master.runner.WorkflowExecuteThread;
import org.apache.dolphinscheduler.service.alert.ProcessAlertManager;
import org.apache.dolphinscheduler.service.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MasterSchedulerService
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(MasterSchedulerService.class);
    @Autowired
    private ProcessService processService;
    @Autowired
    private MasterRegistryClient masterRegistryClient;
    @Autowired
    private MasterConfig masterConfig;
    @Autowired
    private ProcessAlertManager processAlertManager;
    private NettyRemotingClient nettyRemotingClient;
    @Autowired
    NettyExecutorManager nettyExecutorManager;
    private ThreadPoolExecutor masterExecService;
    private ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps;
    ConcurrentHashMap<Integer, ProcessInstance> processTimeoutCheckList = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, TaskInstance> taskTimeoutCheckList = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, TaskInstance> taskRetryCheckList = new ConcurrentHashMap();
    HashMap<String, ProcessDefinition> processDefinitionCacheMaps = new HashMap();
    private StateWheelExecuteThread stateWheelExecuteThread;

    public void init(ConcurrentHashMap<Integer, WorkflowExecuteThread> processInstanceExecMaps) {
        this.processInstanceExecMaps = processInstanceExecMaps;
        this.masterExecService = (ThreadPoolExecutor)ThreadUtils.newDaemonFixedThreadExecutor((String)"Master-Exec-Thread", (int)this.masterConfig.getMasterExecThreads());
        NettyClientConfig clientConfig = new NettyClientConfig();
        this.nettyRemotingClient = new NettyRemotingClient(clientConfig);
        this.stateWheelExecuteThread = new StateWheelExecuteThread(this.processService, this.processTimeoutCheckList, this.taskTimeoutCheckList, this.taskRetryCheckList, this.processInstanceExecMaps, this.masterConfig.getStateWheelInterval() * 1000);
    }

    @Override
    public synchronized void start() {
        super.setName("MasterSchedulerService");
        super.start();
        this.stateWheelExecuteThread.start();
    }

    public void close() {
        this.masterExecService.shutdown();
        boolean terminated = false;
        try {
            terminated = this.masterExecService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
        if (!terminated) {
            logger.warn("masterExecService shutdown without terminated, increase await time");
        }
        this.nettyRemotingClient.close();
        logger.info("master schedule service stopped...");
    }

    @Override
    public void run() {
        logger.info("master scheduler started");
        while (Stopper.isRunning()) {
            try {
                boolean runCheckFlag = OSUtils.checkResource((double)this.masterConfig.getMasterMaxCpuloadAvg(), (double)this.masterConfig.getMasterReservedMemory());
                if (!runCheckFlag) {
                    Thread.sleep(1000L);
                    continue;
                }
                this.scheduleProcess();
            }
            catch (Exception e) {
                logger.error("master scheduler thread error", (Throwable)e);
            }
        }
    }

    private void scheduleProcess() throws Exception {
        Command command = this.findOneCommand();
        if (command != null) {
            logger.info("find one command: id: {}, type: {}", (Object)command.getId(), (Object)command.getCommandType());
            try {
                ProcessInstance processInstance = this.processService.handleCommand(logger, this.getLocalAddress(), command, this.processDefinitionCacheMaps);
                if (!this.masterConfig.getMasterCacheProcessDefinition() && this.processDefinitionCacheMaps.size() > 0) {
                    this.processDefinitionCacheMaps.clear();
                }
                if (processInstance != null) {
                    WorkflowExecuteThread workflowExecuteThread = new WorkflowExecuteThread(processInstance, this.processService, this.nettyExecutorManager, this.processAlertManager, this.masterConfig, this.taskTimeoutCheckList, this.taskRetryCheckList);
                    this.processInstanceExecMaps.put(processInstance.getId(), workflowExecuteThread);
                    if (processInstance.getTimeout() > 0) {
                        this.processTimeoutCheckList.put(processInstance.getId(), processInstance);
                    }
                    logger.info("handle command end, command {} process {} start...", (Object)command.getId(), (Object)processInstance.getId());
                    this.masterExecService.execute(workflowExecuteThread);
                }
            }
            catch (Exception e) {
                logger.error("scan command error ", (Throwable)e);
                this.processService.moveToErrorCommand(command, e.toString());
            }
        } else {
            Thread.sleep(1000L);
        }
    }

    private Command findOneCommand() {
        int pageNumber = 0;
        Command result = null;
        while (Stopper.isRunning()) {
            if (ServerNodeManager.MASTER_SIZE == 0) {
                return null;
            }
            logger.debug("master size:{}", (Object)ServerNodeManager.MASTER_SIZE);
            List commandList = this.processService.findCommandPage(ServerNodeManager.MASTER_SIZE.intValue(), pageNumber);
            if (commandList.size() == 0) {
                return null;
            }
            for (Command command : commandList) {
                int slot = ServerNodeManager.getSlot();
                if (ServerNodeManager.MASTER_SIZE == 0 || command.getId() % ServerNodeManager.MASTER_SIZE != slot) continue;
                result = command;
                break;
            }
            if (result != null) {
                logger.info("find command {}, slot:{} :", (Object)result.getId(), (Object)ServerNodeManager.getSlot());
                break;
            }
            ++pageNumber;
        }
        return result;
    }

    private String getLocalAddress() {
        return NetUtils.getAddr((int)this.masterConfig.getListenPort());
    }
}

