/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.script;

import java.util.Map;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.plugin.alert.script.OSUtils;
import org.apache.dolphinscheduler.plugin.alert.script.ProcessUtils;
import org.apache.dolphinscheduler.plugin.alert.script.ScriptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptSender {
    private static final Logger log = LoggerFactory.getLogger(ScriptSender.class);
    private static final String ALERT_TITLE_OPTION = " -t ";
    private static final String ALERT_CONTENT_OPTION = " -c ";
    private static final String ALERT_USER_PARAMS_OPTION = " -p ";
    private final String scriptPath;
    private final String scriptType;
    private final String userParams;

    ScriptSender(Map<String, String> config) {
        this.scriptPath = config.get("path");
        this.scriptType = config.get("type");
        this.userParams = config.get("userParams");
    }

    AlertResult sendScriptAlert(String title, String content) {
        AlertResult alertResult = new AlertResult();
        if (ScriptType.SHELL.getDescp().equals(this.scriptType)) {
            return this.executeShellScript(title, content);
        }
        return alertResult;
    }

    private AlertResult executeShellScript(String title, String content) {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus("false");
        if (Boolean.TRUE.equals(OSUtils.isWindows())) {
            alertResult.setMessage("shell script not support windows os");
            return alertResult;
        }
        String[] cmd = new String[]{"/bin/sh", "-c", this.scriptPath + ALERT_TITLE_OPTION + "'" + title + "'" + ALERT_CONTENT_OPTION + "'" + content + "'" + ALERT_USER_PARAMS_OPTION + "'" + this.userParams + "'"};
        int exitCode = ProcessUtils.executeScript(cmd);
        if (exitCode == 0) {
            alertResult.setStatus("true");
            alertResult.setMessage("send script alert msg success");
            return alertResult;
        }
        alertResult.setMessage("send script alert msg error,exitCode is " + exitCode);
        log.info("send script alert msg error,exitCode is {}", (Object)exitCode);
        return alertResult;
    }
}

