/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.python;

import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskException;
import org.apache.dolphinscheduler.plugin.task.api.TaskResponse;
import org.apache.dolphinscheduler.plugin.task.python.PythonCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.python.PythonParameters;
import org.apache.dolphinscheduler.plugin.task.util.MapUtils;
import org.apache.dolphinscheduler.spi.task.AbstractParameters;
import org.apache.dolphinscheduler.spi.task.paramparser.ParamUtils;
import org.apache.dolphinscheduler.spi.task.paramparser.ParameterUtils;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;

public class PythonTask
extends AbstractTaskExecutor {
    private PythonParameters pythonParameters;
    private String taskDir;
    private PythonCommandExecutor pythonCommandExecutor;
    private TaskRequest taskRequest;

    public PythonTask(TaskRequest taskRequest) {
        super(taskRequest);
        this.taskRequest = taskRequest;
        this.pythonCommandExecutor = new PythonCommandExecutor(arg_0 -> ((PythonTask)this).logHandle(arg_0), taskRequest, this.logger);
    }

    public void init() {
        this.logger.info("python task params {}", (Object)this.taskRequest.getTaskParams());
        this.pythonParameters = (PythonParameters)((Object)JSONUtils.parseObject((String)this.taskRequest.getTaskParams(), PythonParameters.class));
        if (!this.pythonParameters.checkParameters()) {
            throw new TaskException("python task params is not valid");
        }
    }

    public String getPreScript() {
        String rawPythonScript = this.pythonParameters.getRawScript().replaceAll("\\r\\n", "\n");
        try {
            rawPythonScript = PythonTask.convertPythonScriptPlaceholders(rawPythonScript);
        }
        catch (StringIndexOutOfBoundsException e) {
            this.logger.error("setShareVar field format error, raw python script : {}", (Object)rawPythonScript);
        }
        return rawPythonScript;
    }

    public void handle() throws Exception {
        try {
            String command = this.buildCommand();
            TaskResponse taskResponse = this.pythonCommandExecutor.run(command);
            this.setExitStatusCode(taskResponse.getExitStatusCode());
            this.setAppIds(taskResponse.getAppIds());
            this.setProcessId(taskResponse.getProcessId());
            this.setVarPool(this.pythonCommandExecutor.getVarPool());
        }
        catch (Exception e) {
            this.logger.error("python task failure", (Throwable)e);
            this.setExitStatusCode(-1);
            throw new TaskException("run python task error", (Throwable)e);
        }
    }

    public void cancelApplication(boolean cancelApplication) throws Exception {
        this.pythonCommandExecutor.cancelApplication();
    }

    public AbstractParameters getParameters() {
        return this.pythonParameters;
    }

    private static String convertPythonScriptPlaceholders(String rawScript) throws StringIndexOutOfBoundsException {
        int len = "${setShareVar(${".length();
        int scriptStart = 0;
        while ((scriptStart = rawScript.indexOf("${setShareVar(${", scriptStart)) != -1) {
            int start = -1;
            int end = rawScript.indexOf(125, scriptStart + len);
            String prop = rawScript.substring(scriptStart + len, end);
            start = rawScript.indexOf(44, end);
            end = rawScript.indexOf(41, start);
            String value = rawScript.substring(start + 1, end);
            start = rawScript.indexOf(125, start) + 1;
            end = rawScript.length();
            String replaceScript = String.format("print(\"${{setValue({},{})}}\".format(\"%s\",%s))", prop, value);
            rawScript = rawScript.substring(0, scriptStart) + replaceScript + rawScript.substring(start, end);
            scriptStart += replaceScript.length();
        }
        return rawScript;
    }

    private String buildCommand() throws Exception {
        String rawPythonScript = this.pythonParameters.getRawScript().replaceAll("\\r\\n", "\n");
        HashMap paramsMap = ParamUtils.convert((TaskRequest)this.taskRequest, (AbstractParameters)this.pythonParameters);
        if (MapUtils.isEmpty((Map)paramsMap)) {
            paramsMap = new HashMap();
        }
        if (MapUtils.isNotEmpty((Map)this.taskRequest.getParamsMap())) {
            paramsMap.putAll(this.taskRequest.getParamsMap());
        }
        rawPythonScript = ParameterUtils.convertParameterPlaceholders((String)rawPythonScript, (Map)ParamUtils.convert(paramsMap));
        this.logger.info("raw python script : {}", (Object)this.pythonParameters.getRawScript());
        this.logger.info("task dir : {}", (Object)this.taskDir);
        return rawPythonScript;
    }
}

