/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.python;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractCommandExecutor;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonCommandExecutor
extends AbstractCommandExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PythonCommandExecutor.class);
    public static final String PYTHON = "python";
    private static final Pattern PYTHON_PATH_PATTERN = Pattern.compile("/bin/python[\\d.]*$");

    public PythonCommandExecutor(Consumer<LinkedBlockingQueue<String>> logHandler, TaskRequest taskRequest, Logger logger) {
        super(logHandler, taskRequest, logger);
    }

    protected String buildCommandFilePath() {
        return String.format("%s/py_%s.command", this.taskRequest.getExecutePath(), this.taskRequest.getTaskAppId());
    }

    protected void createCommandFileIfNotExists(String execCommand, String commandFile) throws IOException {
        logger.info("tenantCode :{}, task dir:{}", (Object)this.taskRequest.getTenantCode(), (Object)this.taskRequest.getExecutePath());
        if (!Files.exists(Paths.get(commandFile, new String[0]), new LinkOption[0])) {
            logger.info("generate command file:{}", (Object)commandFile);
            StringBuilder sb = new StringBuilder();
            sb.append("#-*- encoding=utf8 -*-\n");
            sb.append("\n\n");
            sb.append(execCommand);
            logger.info(sb.toString());
            FileUtils.writeStringToFile((File)new File(commandFile), (String)sb.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPythonHome(String envPath) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(envPath)));){
            String result;
            String line;
            while ((line = br.readLine()) != null) {
                if (!line.contains("PYTHON_HOME")) continue;
                sb.append(line);
                break;
            }
            if (StringUtils.isEmpty((CharSequence)(result = sb.toString()))) {
                String string = null;
                return string;
            }
            String[] arrs = result.split("=");
            if (arrs.length != 2) return null;
            String string = arrs[1];
            return string;
        }
        catch (IOException e) {
            logger.error("read file failure", (Throwable)e);
        }
        return null;
    }

    protected String commandInterpreter() {
        String pythonHome = PythonCommandExecutor.getPythonHome(this.taskRequest.getEnvFile());
        if (StringUtils.isNotBlank((CharSequence)this.taskRequest.getEnvironmentConfig())) {
            pythonHome = PythonCommandExecutor.getPythonHomeFromEnvironmentConfig(this.taskRequest.getEnvironmentConfig());
        }
        return PythonCommandExecutor.getPythonCommand(pythonHome);
    }

    public static String getPythonCommand(String pythonHome) {
        if (StringUtils.isEmpty((CharSequence)pythonHome)) {
            return PYTHON;
        }
        File file = new File(pythonHome);
        if (file.exists() && file.isFile()) {
            return pythonHome;
        }
        if (PYTHON_PATH_PATTERN.matcher(pythonHome).find()) {
            return pythonHome;
        }
        return Paths.get(pythonHome, "/bin/python").toString();
    }

    public static String getPythonHomeFromEnvironmentConfig(String environmentConfig) {
        String[] lines = environmentConfig.split("\n");
        String pythonHomeConfig = Arrays.stream(lines).filter(line -> line.contains("PYTHON_HOME")).findFirst().get();
        if (StringUtils.isEmpty((CharSequence)pythonHomeConfig)) {
            return null;
        }
        String[] arrs = pythonHomeConfig.split("=");
        if (arrs.length == 2) {
            return arrs[1];
        }
        return null;
    }
}

