/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.zookeeper;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.dolphinscheduler.plugin.registry.zookeeper.ZookeeperConfiguration;
import org.apache.dolphinscheduler.plugin.registry.zookeeper.ZookeeperConnectionStateListener;
import org.apache.dolphinscheduler.spi.register.DataChangeEvent;
import org.apache.dolphinscheduler.spi.register.ListenerManager;
import org.apache.dolphinscheduler.spi.register.Registry;
import org.apache.dolphinscheduler.spi.register.RegistryConnectListener;
import org.apache.dolphinscheduler.spi.register.RegistryException;
import org.apache.dolphinscheduler.spi.register.SubscribeListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class ZookeeperRegistry
implements Registry {
    private CuratorFramework client;
    private Map<String, TreeCache> treeCacheMap = new HashMap<String, TreeCache>();
    private ThreadLocal<Map<String, InterProcessMutex>> threadLocalLockMap = new ThreadLocal();

    private static RetryPolicy buildRetryPolicy(Map<String, String> registerData) {
        int baseSleepTimeMs = (Integer)ZookeeperConfiguration.BASE_SLEEP_TIME.getParameterValue(registerData.get(ZookeeperConfiguration.BASE_SLEEP_TIME.getName()));
        int maxRetries = (Integer)ZookeeperConfiguration.MAX_RETRIES.getParameterValue(registerData.get(ZookeeperConfiguration.MAX_RETRIES.getName()));
        int maxSleepMs = baseSleepTimeMs * maxRetries;
        return new ExponentialBackoffRetry(baseSleepTimeMs, maxRetries, maxSleepMs);
    }

    private static void buildDigest(CuratorFrameworkFactory.Builder builder, String digest) {
        builder.authorization(ZookeeperConfiguration.DIGEST.getName(), digest.getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

            public List<ACL> getDefaultAcl() {
                return ZooDefs.Ids.CREATOR_ALL_ACL;
            }

            public List<ACL> getAclForPath(String path) {
                return ZooDefs.Ids.CREATOR_ALL_ACL;
            }
        });
    }

    public void init(Map<String, String> registerData) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString((String)ZookeeperConfiguration.SERVERS.getParameterValue(registerData.get(ZookeeperConfiguration.SERVERS.getName()))).retryPolicy(ZookeeperRegistry.buildRetryPolicy(registerData)).namespace((String)ZookeeperConfiguration.NAME_SPACE.getParameterValue(registerData.get(ZookeeperConfiguration.NAME_SPACE.getName()))).sessionTimeoutMs(((Integer)ZookeeperConfiguration.SESSION_TIMEOUT_MS.getParameterValue(registerData.get(ZookeeperConfiguration.SESSION_TIMEOUT_MS.getName()))).intValue()).connectionTimeoutMs(((Integer)ZookeeperConfiguration.CONNECTION_TIMEOUT_MS.getParameterValue(registerData.get(ZookeeperConfiguration.CONNECTION_TIMEOUT_MS.getName()))).intValue());
        String digest = (String)ZookeeperConfiguration.DIGEST.getParameterValue(registerData.get(ZookeeperConfiguration.DIGEST.getName()));
        if (!Strings.isNullOrEmpty((String)digest)) {
            ZookeeperRegistry.buildDigest(builder, digest);
        }
        this.client = builder.build();
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(((Integer)ZookeeperConfiguration.BLOCK_UNTIL_CONNECTED_WAIT_MS.getParameterValue(registerData.get(ZookeeperConfiguration.BLOCK_UNTIL_CONNECTED_WAIT_MS.getName()))).intValue(), TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new RegistryException("zookeeper connect timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException("zookeeper connect error", (Throwable)e);
        }
    }

    public void addConnectionStateListener(RegistryConnectListener registryConnectListener) {
        this.client.getConnectionStateListenable().addListener((Object)new ZookeeperConnectionStateListener(registryConnectListener));
    }

    public boolean subscribe(String path, SubscribeListener subscribeListener) {
        if (null != this.treeCacheMap.get(path)) {
            return false;
        }
        TreeCache treeCache = new TreeCache(this.client, path);
        TreeCacheListener treeCacheListener = (client, event) -> {
            TreeCacheEvent.Type type = event.getType();
            DataChangeEvent eventType = null;
            String dataPath = null;
            switch (type) {
                case NODE_ADDED: {
                    dataPath = event.getData().getPath();
                    eventType = DataChangeEvent.ADD;
                    break;
                }
                case NODE_UPDATED: {
                    eventType = DataChangeEvent.UPDATE;
                    dataPath = event.getData().getPath();
                    break;
                }
                case NODE_REMOVED: {
                    eventType = DataChangeEvent.REMOVE;
                    dataPath = event.getData().getPath();
                    break;
                }
            }
            if (null != eventType && null != dataPath) {
                ListenerManager.dataChange((String)path, (String)dataPath, (String)new String(event.getData().getData()), (DataChangeEvent)eventType);
            }
        };
        treeCache.getListenable().addListener((Object)treeCacheListener);
        this.treeCacheMap.put(path, treeCache);
        try {
            treeCache.start();
        }
        catch (Exception e) {
            throw new RegistryException("start zookeeper tree cache error", (Throwable)e);
        }
        ListenerManager.addListener((String)path, (SubscribeListener)subscribeListener);
        return true;
    }

    public void unsubscribe(String path) {
        TreeCache treeCache = this.treeCacheMap.get(path);
        treeCache.close();
        ListenerManager.removeListener((String)path);
    }

    public String get(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper get data error", (Throwable)e);
        }
    }

    public void remove(String key) {
        this.delete(key);
    }

    public boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper check key is existed error", (Throwable)e);
        }
    }

    public void persist(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.update(key, value);
                return;
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper persist error", (Throwable)e);
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.update(key, value);
                return;
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper persist ephemeral error", (Throwable)e);
        }
    }

    public void update(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                return;
            }
            TransactionOp transactionOp = this.client.transactionOp();
            this.client.transaction().forOperations(new CuratorOp[]{(CuratorOp)transactionOp.check().forPath(key), (CuratorOp)transactionOp.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8))});
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper update error", (Throwable)e);
        }
    }

    public List<String> getChildren(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper get children error", (Throwable)e);
        }
    }

    public boolean delete(String nodePath) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(nodePath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper delete key error", (Throwable)e);
        }
        return true;
    }

    public boolean acquireLock(String key) {
        InterProcessMutex interProcessMutex = new InterProcessMutex(this.client, key);
        try {
            interProcessMutex.acquire();
            if (null == this.threadLocalLockMap.get()) {
                this.threadLocalLockMap.set(new HashMap(3));
            }
            this.threadLocalLockMap.get().put(key, interProcessMutex);
            return true;
        }
        catch (Exception e) {
            try {
                interProcessMutex.release();
                throw new RegistryException("zookeeper get lock error", (Throwable)e);
            }
            catch (Exception exception) {
                throw new RegistryException("zookeeper release lock error", (Throwable)e);
            }
        }
    }

    public boolean releaseLock(String key) {
        if (null == this.threadLocalLockMap.get().get(key)) {
            return false;
        }
        try {
            this.threadLocalLockMap.get().get(key).release();
            this.threadLocalLockMap.get().remove(key);
            if (this.threadLocalLockMap.get().isEmpty()) {
                this.threadLocalLockMap.remove();
            }
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper release lock error", (Throwable)e);
        }
        return true;
    }

    public CuratorFramework getClient() {
        return this.client;
    }

    public void close() {
        this.treeCacheMap.forEach((key, value) -> value.close());
        this.waitForCacheClose(500L);
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

