/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.dolphinscheduler.spi.register.RegistryConnectListener;
import org.apache.dolphinscheduler.spi.register.RegistryConnectState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperConnectionStateListener
implements ConnectionStateListener {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperConnectionStateListener.class);
    private RegistryConnectListener registryConnectListener;

    public ZookeeperConnectionStateListener(RegistryConnectListener registryConnectListener) {
        this.registryConnectListener = registryConnectListener;
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (newState == ConnectionState.LOST) {
            logger.error("connection lost from zookeeper");
            this.registryConnectListener.notify(RegistryConnectState.LOST);
        } else if (newState == ConnectionState.RECONNECTED) {
            logger.info("reconnected to zookeeper");
            this.registryConnectListener.notify(RegistryConnectState.RECONNECTED);
        } else if (newState == ConnectionState.SUSPENDED) {
            logger.warn("zookeeper connection SUSPENDED");
            this.registryConnectListener.notify(RegistryConnectState.SUSPENDED);
        }
    }
}

