/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.dingtalk;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.dolphinscheduler.spi.alert.AlertResult;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingTalkSender {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkSender.class);
    private String url;
    private String keyword;
    private Boolean enableProxy;
    private String proxy;
    private Integer port;
    private String user;
    private String password;

    DingTalkSender(Map<String, String> config) {
        this.url = config.get("WebHook");
        this.keyword = config.get("Keyword");
        this.enableProxy = Boolean.valueOf(config.get("IsEnableProxy"));
        if (Boolean.TRUE.equals(this.enableProxy)) {
            this.port = Integer.parseInt(config.get("Port"));
            this.proxy = config.get("Proxy");
            this.user = config.get("user");
            this.password = config.get("Password");
        }
    }

    private static HttpPost constructHttpPost(String url, String msg, String charset) {
        HttpPost post = new HttpPost(url);
        StringEntity entity = new StringEntity(msg, charset);
        post.setEntity((HttpEntity)entity);
        post.addHeader("Content-Type", "application/json; charset=utf-8");
        return post;
    }

    private static CloseableHttpClient getProxyClient(String proxy, int port, String user, String password) {
        HttpHost httpProxy = new HttpHost(proxy, port);
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        provider.setCredentials(new AuthScope(httpProxy), (Credentials)new UsernamePasswordCredentials(user, password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
    }

    private static CloseableHttpClient getDefaultClient() {
        return HttpClients.createDefault();
    }

    private static RequestConfig getProxyConfig(String proxy, int port) {
        HttpHost httpProxy = new HttpHost(proxy, port);
        return RequestConfig.custom().setProxy(httpProxy).build();
    }

    private static String textToJsonString(String text) {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("msgtype", "text");
        HashMap<String, String> textContent = new HashMap<String, String>();
        byte[] byt = StringUtils.getBytesUtf8((String)text);
        String txt = StringUtils.newStringUtf8((byte[])byt);
        textContent.put("content", txt);
        items.put("text", textContent);
        return JSONUtils.toJsonString(items);
    }

    private static AlertResult checkSendDingTalkSendMsgResult(String result) {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus("false");
        if (null == result) {
            alertResult.setMessage("send ding talk msg error");
            logger.info("send ding talk msg error,ding talk server resp is null");
            return alertResult;
        }
        DingTalkSendMsgResponse sendMsgResponse = (DingTalkSendMsgResponse)JSONUtils.parseObject((String)result, DingTalkSendMsgResponse.class);
        if (null == sendMsgResponse) {
            alertResult.setMessage("send ding talk msg fail");
            logger.info("send ding talk msg error,resp error");
            return alertResult;
        }
        if (sendMsgResponse.errcode == 0) {
            alertResult.setStatus("true");
            alertResult.setMessage("send ding talk msg success");
            return alertResult;
        }
        alertResult.setMessage(String.format("alert send ding talk msg error : %s", sendMsgResponse.getErrmsg()));
        logger.info("alert send ding talk msg error : {}", (Object)sendMsgResponse.getErrmsg());
        return alertResult;
    }

    public AlertResult sendDingTalkMsg(String title, String content) {
        try {
            String resp = this.sendMsg(title, content);
            return DingTalkSender.checkSendDingTalkSendMsgResult(resp);
        }
        catch (Exception e) {
            logger.info("send ding talk alert msg  exception : {}", (Object)e.getMessage());
            AlertResult alertResult = new AlertResult();
            alertResult.setStatus("false");
            alertResult.setMessage("send ding talk alert fail.");
            return alertResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendMsg(String title, String content) throws IOException {
        CloseableHttpClient httpClient;
        String msgToJson = DingTalkSender.textToJsonString(title + content + "#" + this.keyword);
        HttpPost httpPost = DingTalkSender.constructHttpPost(this.url, msgToJson, "UTF-8");
        if (Boolean.TRUE.equals(this.enableProxy)) {
            httpClient = DingTalkSender.getProxyClient(this.proxy, this.port, this.user, this.password);
            RequestConfig rcf = DingTalkSender.getProxyConfig(this.proxy, this.port);
            httpPost.setConfig(rcf);
        } else {
            httpClient = DingTalkSender.getDefaultClient();
        }
        try {
            String resp;
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                HttpEntity entity = response.getEntity();
                resp = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                EntityUtils.consume((HttpEntity)entity);
            }
            logger.info("Ding Talk send title :{},content : {}, resp: {}", new Object[]{title, content, resp});
            String string = resp;
            return string;
        }
        finally {
            httpClient.close();
        }
    }

    public static class DingTalkSendMsgResponse {
        private Integer errcode;
        private String errmsg;

        public Integer getErrcode() {
            return this.errcode;
        }

        public void setErrcode(Integer errcode) {
            this.errcode = errcode;
        }

        public String getErrmsg() {
            return this.errmsg;
        }

        public void setErrmsg(String errmsg) {
            this.errmsg = errmsg;
        }
    }
}

