/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUtils {
    private static final Logger logger = LoggerFactory.getLogger(SchemaUtils.class);
    private static Pattern p = Pattern.compile("\\s*|\t|\r|\n");

    private SchemaUtils() {
        throw new UnsupportedOperationException("Construct SchemaUtils");
    }

    public static List<String> getAllSchemaList() {
        ArrayList<String> schemaDirList = new ArrayList<String>();
        File[] schemaDirArr = FileUtils.getAllDir("sql/upgrade");
        if (schemaDirArr == null || schemaDirArr.length == 0) {
            return null;
        }
        for (File file : schemaDirArr) {
            schemaDirList.add(file.getName());
        }
        Collections.sort(schemaDirList, new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    String dir1 = String.valueOf(o1);
                    String dir2 = String.valueOf(o2);
                    String version1 = dir1.split("_")[0];
                    String version2 = dir2.split("_")[0];
                    if (version1.equals(version2)) {
                        return 0;
                    }
                    if (SchemaUtils.isAGreatVersion(version1, version2)) {
                        return 1;
                    }
                    return -1;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
        return schemaDirList;
    }

    public static boolean isAGreatVersion(String schemaVersion, String version) {
        if (StringUtils.isEmpty((String)schemaVersion) || StringUtils.isEmpty((String)version)) {
            throw new RuntimeException("schemaVersion or version is empty");
        }
        String[] schemaVersionArr = schemaVersion.split("\\.");
        String[] versionArr = version.split("\\.");
        int arrLength = Math.min(schemaVersionArr.length, versionArr.length);
        for (int i = 0; i < arrLength; ++i) {
            if (Integer.parseInt(schemaVersionArr[i]) > Integer.parseInt(versionArr[i])) {
                return true;
            }
            if (Integer.parseInt(schemaVersionArr[i]) >= Integer.parseInt(versionArr[i])) continue;
            return false;
        }
        return schemaVersionArr.length > versionArr.length;
    }

    public static String getSoftVersion() {
        String softVersion;
        try {
            softVersion = FileUtils.readFile2Str(new FileInputStream(new File("sql/soft_version")));
            softVersion = SchemaUtils.replaceBlank(softVersion);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to get the product version description file. The file could not be found", e);
        }
        return softVersion;
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }
}

