/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanMap;
import org.apache.commons.lang.StringUtils;

public class CollectionUtils {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;

    private CollectionUtils() {
        throw new UnsupportedOperationException("Construct CollectionUtils");
    }

    public static <T> Collection<T> subtract(Set<T> a, Set<T> b) {
        return org.apache.commons.collections4.CollectionUtils.subtract(a, b);
    }

    public static boolean isNotEmpty(Collection coll) {
        return !CollectionUtils.isEmpty(coll);
    }

    public static boolean isEmpty(Collection coll) {
        return coll == null || coll.isEmpty();
    }

    public static Map<String, String> stringToMap(String str, String separator) {
        return CollectionUtils.stringToMap(str, separator, "");
    }

    public static Map<String, String> stringToMap(String str, String separator, String keyPrefix) {
        HashMap<String, String> emptyMap = new HashMap<String, String>(0);
        if (StringUtils.isEmpty((String)str)) {
            return emptyMap;
        }
        if (StringUtils.isEmpty((String)separator)) {
            return emptyMap;
        }
        String[] strings = str.split(separator);
        int initialCapacity = (int)((float)strings.length / 0.75f) + 1;
        HashMap<String, String> map = new HashMap<String, String>(initialCapacity);
        for (int i = 0; i < strings.length; ++i) {
            String[] strArray = strings[i].split("=");
            if (strArray.length != 2) {
                return emptyMap;
            }
            if (StringUtils.isEmpty((String)keyPrefix)) {
                map.put(strArray[0], strArray[1]);
                continue;
            }
            map.put(keyPrefix + strArray[0], strArray[1]);
        }
        return map;
    }

    public static <R, T> List<T> transformToList(Collection<R> collection, Function<R, T> transformFunc) {
        if (CollectionUtils.isEmpty(collection)) {
            return new ArrayList();
        }
        return collection.stream().map(transformFunc).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> collectionToMap(Collection<V> collection, Function<V, K> keyTransformFunction) {
        if (CollectionUtils.isEmpty(collection)) {
            return new HashMap();
        }
        return collection.stream().collect(Collectors.toMap(keyTransformFunction, Function.identity()));
    }

    public static boolean equalLists(Collection<?> a, Collection<?> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return CollectionUtils.isEqualCollection(a, b);
    }

    public static boolean isEqualCollection(Collection<?> a, Collection<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        CardinalityHelper helper = new CardinalityHelper(a, b);
        if (helper.cardinalityA.size() != helper.cardinalityB.size()) {
            return false;
        }
        for (Object obj : helper.cardinalityA.keySet()) {
            if (helper.freqA(obj) == helper.freqB(obj)) continue;
            return false;
        }
        return true;
    }

    public static <O> Map<O, Integer> getCardinalityMap(Iterable<? extends O> coll) {
        HashMap<O, Integer> count = new HashMap<O, Integer>();
        for (O obj : coll) {
            count.put(obj, count.getOrDefault(obj, 0) + 1);
        }
        return count;
    }

    public static <T> List<Map<String, Object>> getListByExclusion(List<T> originList, Set<String> exclusionSet) {
        ArrayList<Map<String, Object>> instanceList = new ArrayList<Map<String, Object>>();
        if (exclusionSet == null) {
            exclusionSet = new HashSet<String>();
        }
        if (originList == null) {
            return instanceList;
        }
        for (T instance : originList) {
            BeanMap beanMap = new BeanMap(instance);
            LinkedHashMap instanceMap = new LinkedHashMap(16, 0.75f, true);
            for (Map.Entry entry : beanMap.entrySet()) {
                if (exclusionSet.contains(entry.getKey())) continue;
                instanceMap.put((String)entry.getKey(), entry.getValue());
            }
            instanceList.add(instanceMap);
        }
        return instanceList;
    }

    private static class CardinalityHelper<O> {
        final Map<O, Integer> cardinalityA;
        final Map<O, Integer> cardinalityB;

        public CardinalityHelper(Iterable<? extends O> a, Iterable<? extends O> b) {
            this.cardinalityA = CollectionUtils.getCardinalityMap(a);
            this.cardinalityB = CollectionUtils.getCardinalityMap(b);
        }

        public int freqA(Object obj) {
            return this.getFreq(obj, this.cardinalityA);
        }

        public int freqB(Object obj) {
            return this.getFreq(obj, this.cardinalityB);
        }

        private int getFreq(Object obj, Map<?, Integer> freqMap) {
            Integer count = freqMap.get(obj);
            if (count != null) {
                return count;
            }
            return 0;
        }
    }
}

