/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.datasource;

import java.sql.Connection;
import org.apache.dolphinscheduler.common.datasource.BaseDataSourceParamDTO;
import org.apache.dolphinscheduler.common.datasource.ConnectionParam;
import org.apache.dolphinscheduler.common.datasource.DatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.clickhouse.ClickHouseDatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.db2.Db2DatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.hive.HiveDatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.mysql.MysqlDatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.oracle.OracleDatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.postgresql.PostgreSqlDatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.presto.PrestoDatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.spark.SparkDatasourceProcessor;
import org.apache.dolphinscheduler.common.datasource.sqlserver.SqlServerDatasourceProcessor;
import org.apache.dolphinscheduler.common.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceUtil.class);
    private static final DatasourceProcessor mysqlProcessor = new MysqlDatasourceProcessor();
    private static final DatasourceProcessor postgreSqlProcessor = new PostgreSqlDatasourceProcessor();
    private static final DatasourceProcessor hiveProcessor = new HiveDatasourceProcessor();
    private static final DatasourceProcessor sparkProcessor = new SparkDatasourceProcessor();
    private static final DatasourceProcessor clickhouseProcessor = new ClickHouseDatasourceProcessor();
    private static final DatasourceProcessor oracleProcessor = new OracleDatasourceProcessor();
    private static final DatasourceProcessor sqlServerProcessor = new SqlServerDatasourceProcessor();
    private static final DatasourceProcessor db2PROCESSOR = new Db2DatasourceProcessor();
    private static final DatasourceProcessor prestoPROCESSOR = new PrestoDatasourceProcessor();

    private DatasourceUtil() {
    }

    public static void checkDatasourceParam(BaseDataSourceParamDTO baseDataSourceParamDTO) {
        DatasourceUtil.getDatasourceProcessor(baseDataSourceParamDTO.getType()).checkDatasourceParam(baseDataSourceParamDTO);
    }

    public static ConnectionParam buildConnectionParams(BaseDataSourceParamDTO baseDataSourceParamDTO) {
        ConnectionParam connectionParams = DatasourceUtil.getDatasourceProcessor(baseDataSourceParamDTO.getType()).createConnectionParams(baseDataSourceParamDTO);
        if (logger.isDebugEnabled()) {
            logger.info("parameters map:{}", (Object)connectionParams);
        }
        return connectionParams;
    }

    public static ConnectionParam buildConnectionParams(DbType dbType, String connectionJson) {
        return DatasourceUtil.getDatasourceProcessor(dbType).createConnectionParams(connectionJson);
    }

    public static Connection getConnection(DbType dbType, ConnectionParam connectionParam) {
        try {
            return DatasourceUtil.getDatasourceProcessor(dbType).getConnection(connectionParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJdbcUrl(DbType dbType, ConnectionParam baseConnectionParam) {
        return DatasourceUtil.getDatasourceProcessor(dbType).getJdbcUrl(baseConnectionParam);
    }

    public static BaseDataSourceParamDTO buildDatasourceParamDTO(DbType dbType, String connectionParams) {
        return DatasourceUtil.getDatasourceProcessor(dbType).createDatasourceParamDTO(connectionParams);
    }

    public static DatasourceProcessor getDatasourceProcessor(DbType dbType) {
        switch (dbType) {
            case MYSQL: {
                return mysqlProcessor;
            }
            case POSTGRESQL: {
                return postgreSqlProcessor;
            }
            case HIVE: {
                return hiveProcessor;
            }
            case SPARK: {
                return sparkProcessor;
            }
            case CLICKHOUSE: {
                return clickhouseProcessor;
            }
            case ORACLE: {
                return oracleProcessor;
            }
            case SQLSERVER: {
                return sqlServerProcessor;
            }
            case DB2: {
                return db2PROCESSOR;
            }
            case PRESTO: {
                return prestoPROCESSOR;
            }
        }
        throw new IllegalArgumentException("datasource type illegal:" + (Object)((Object)dbType));
    }
}

