/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.Aliases;
import com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.StreamingDistributionConfig;
import com.amazonaws.services.cloudfront.model.StreamingLoggingConfig;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateStreamingDistributionRequestMarshaller
implements Marshaller<Request<CreateStreamingDistributionRequest>, CreateStreamingDistributionRequest> {
    @Override
    public Request<CreateStreamingDistributionRequest> marshall(CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        StreamingDistributionConfig streamingDistributionConfigStreamingDistributionConfig;
        if (createStreamingDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateStreamingDistributionRequest> request = new DefaultRequest<CreateStreamingDistributionRequest>(createStreamingDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2014-01-31/streaming-distribution";
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2014-01-31/");
        if (createStreamingDistributionRequest != null && (streamingDistributionConfigStreamingDistributionConfig = createStreamingDistributionRequest.getStreamingDistributionConfig()) != null) {
            TrustedSigners trustedSignersTrustedSigners;
            StreamingLoggingConfig streamingLoggingConfigLogging;
            Aliases aliasesAliases;
            S3Origin s3OriginS3Origin;
            xmlWriter.startElement("StreamingDistributionConfig");
            if (streamingDistributionConfigStreamingDistributionConfig.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(streamingDistributionConfigStreamingDistributionConfig.getCallerReference()).endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig != null && (s3OriginS3Origin = streamingDistributionConfigStreamingDistributionConfig.getS3Origin()) != null) {
                xmlWriter.startElement("S3Origin");
                if (s3OriginS3Origin.getDomainName() != null) {
                    xmlWriter.startElement("DomainName").value(s3OriginS3Origin.getDomainName()).endElement();
                }
                if (s3OriginS3Origin.getOriginAccessIdentity() != null) {
                    xmlWriter.startElement("OriginAccessIdentity").value(s3OriginS3Origin.getOriginAccessIdentity()).endElement();
                }
                xmlWriter.endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig != null && (aliasesAliases = streamingDistributionConfigStreamingDistributionConfig.getAliases()) != null) {
                List<String> aliasesAliasesitemsList;
                xmlWriter.startElement("Aliases");
                if (aliasesAliases.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value(aliasesAliases.getQuantity()).endElement();
                }
                if (aliasesAliases != null && (aliasesAliasesitemsList = aliasesAliases.getItems()) != null && aliasesAliasesitemsList.size() > 0) {
                    int aliasesAliasesitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (String aliasesAliasesitemsListValue : aliasesAliasesitemsList) {
                        xmlWriter.startElement("CNAME");
                        xmlWriter.value(aliasesAliasesitemsListValue);
                        xmlWriter.endElement();
                        ++aliasesAliasesitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig.getComment() != null) {
                xmlWriter.startElement("Comment").value(streamingDistributionConfigStreamingDistributionConfig.getComment()).endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig != null && (streamingLoggingConfigLogging = streamingDistributionConfigStreamingDistributionConfig.getLogging()) != null) {
                xmlWriter.startElement("Logging");
                if (streamingLoggingConfigLogging.isEnabled() != null) {
                    xmlWriter.startElement("Enabled").value(streamingLoggingConfigLogging.isEnabled()).endElement();
                }
                if (streamingLoggingConfigLogging.getBucket() != null) {
                    xmlWriter.startElement("Bucket").value(streamingLoggingConfigLogging.getBucket()).endElement();
                }
                if (streamingLoggingConfigLogging.getPrefix() != null) {
                    xmlWriter.startElement("Prefix").value(streamingLoggingConfigLogging.getPrefix()).endElement();
                }
                xmlWriter.endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig != null && (trustedSignersTrustedSigners = streamingDistributionConfigStreamingDistributionConfig.getTrustedSigners()) != null) {
                List<String> trustedSignersTrustedSignersitemsList;
                xmlWriter.startElement("TrustedSigners");
                if (trustedSignersTrustedSigners.isEnabled() != null) {
                    xmlWriter.startElement("Enabled").value(trustedSignersTrustedSigners.isEnabled()).endElement();
                }
                if (trustedSignersTrustedSigners.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value(trustedSignersTrustedSigners.getQuantity()).endElement();
                }
                if (trustedSignersTrustedSigners != null && (trustedSignersTrustedSignersitemsList = trustedSignersTrustedSigners.getItems()) != null && trustedSignersTrustedSignersitemsList.size() > 0) {
                    int trustedSignersTrustedSignersitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (String trustedSignersTrustedSignersitemsListValue : trustedSignersTrustedSignersitemsList) {
                        xmlWriter.startElement("AwsAccountNumber");
                        xmlWriter.value(trustedSignersTrustedSignersitemsListValue);
                        xmlWriter.endElement();
                        ++trustedSignersTrustedSignersitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig.getPriceClass() != null) {
                xmlWriter.startElement("PriceClass").value(streamingDistributionConfigStreamingDistributionConfig.getPriceClass()).endElement();
            }
            if (streamingDistributionConfigStreamingDistributionConfig.isEnabled() != null) {
                xmlWriter.startElement("Enabled").value(streamingDistributionConfigStreamingDistributionConfig.isEnabled()).endElement();
            }
            xmlWriter.endElement();
        }
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

