/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.tenant;

import com.baomidou.mybatisplus.core.parser.AbstractJsqlParser;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.extension.plugins.tenant.TenantHandler;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.expression.operators.relational.SupportsOldOracleJoinSyntax;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;

public class TenantSqlParser
extends AbstractJsqlParser {
    private TenantHandler tenantHandler;

    public void processSelectBody(SelectBody selectBody) {
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            if (withItem.getSelectBody() != null) {
                this.processSelectBody(withItem.getSelectBody());
            }
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            if (operationList.getSelects() != null && operationList.getSelects().size() > 0) {
                operationList.getSelects().forEach(this::processSelectBody);
            }
        }
    }

    public void processInsert(Insert insert) {
        if (this.tenantHandler.doTableFilter(insert.getTable().getName())) {
            return;
        }
        insert.getColumns().add(new Column(this.tenantHandler.getTenantIdColumn()));
        if (insert.getSelect() != null) {
            this.processPlainSelect((PlainSelect)insert.getSelect().getSelectBody(), true);
        } else if (insert.getItemsList() != null) {
            ItemsList itemsList = insert.getItemsList();
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExprList().forEach(el -> el.getExpressions().add(this.tenantHandler.getTenantId(false)));
            } else {
                ((ExpressionList)insert.getItemsList()).getExpressions().add(this.tenantHandler.getTenantId(false));
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    public void processUpdate(Update update) {
        List tableList = update.getTables();
        Assert.isTrue((null != tableList && tableList.size() < 2 ? 1 : 0) != 0, (String)"Failed to process multiple-table update, please exclude the statementId", (Object[])new Object[0]);
        Table table = (Table)tableList.get(0);
        if (this.tenantHandler.doTableFilter(table.getName())) {
            return;
        }
        update.setWhere((Expression)this.andExpression(table, update.getWhere()));
    }

    public void processDelete(Delete delete) {
        if (this.tenantHandler.doTableFilter(delete.getTable().getName())) {
            return;
        }
        delete.setWhere((Expression)this.andExpression(delete.getTable(), delete.getWhere()));
    }

    protected BinaryExpression andExpression(Table table, Expression where) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.getAliasColumn(table));
        equalsTo.setRightExpression(this.tenantHandler.getTenantId(true));
        if (null != where) {
            if (where instanceof OrExpression) {
                return new AndExpression((Expression)equalsTo, (Expression)new Parenthesis(where));
            }
            return new AndExpression((Expression)equalsTo, where);
        }
        return equalsTo;
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        this.processPlainSelect(plainSelect, false);
    }

    protected void processPlainSelect(PlainSelect plainSelect, boolean addColumn) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (!this.getTenantHandler().doTableFilter(fromTable.getName())) {
                plainSelect.setWhere(this.builderExpression(plainSelect.getWhere(), fromTable));
                if (addColumn) {
                    plainSelect.getSelectItems().add(new SelectExpressionItem((Expression)new Column(this.getTenantHandler().getTenantIdColumn())));
                }
            }
        } else {
            this.processFromItem(fromItem);
        }
        List joins = plainSelect.getJoins();
        if (joins != null && joins.size() > 0) {
            joins.forEach(j -> {
                this.processJoin((Join)j);
                this.processFromItem(j.getRightItem());
            });
        }
    }

    protected void processFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        if (fromItem instanceof SubJoin) {
            SubJoin subJoin = (SubJoin)fromItem;
            if (subJoin.getJoinList() != null) {
                subJoin.getJoinList().forEach(this::processJoin);
            }
            if (subJoin.getLeft() != null) {
                this.processFromItem(subJoin.getLeft());
            }
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (fromItem instanceof ValuesList) {
            this.logger.debug("Perform a subquery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    protected void processJoin(Join join) {
        if (join.getRightItem() instanceof Table) {
            Table fromTable = (Table)join.getRightItem();
            if (this.tenantHandler.doTableFilter(fromTable.getName())) {
                return;
            }
            join.setOnExpression(this.builderExpression(join.getOnExpression(), fromTable));
        }
    }

    protected Expression builderExpression(Expression currentExpression, Table table) {
        InExpression inExp;
        ItemsList rightItems;
        EqualsTo appendExpression;
        Expression tenantExpression = this.getTenantHandler().getTenantId(false);
        if (!(tenantExpression instanceof SupportsOldOracleJoinSyntax)) {
            appendExpression = new EqualsTo();
            appendExpression.setLeftExpression((Expression)this.getAliasColumn(table));
            appendExpression.setRightExpression(tenantExpression);
        } else {
            appendExpression = this.processTableAlias4CustomizedTenantIdExpression(tenantExpression, table);
        }
        if (currentExpression == null) {
            return appendExpression;
        }
        if (currentExpression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)currentExpression;
            if (binaryExpression.getLeftExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getLeftExpression());
            }
            if (binaryExpression.getRightExpression() instanceof FromItem) {
                this.processFromItem((FromItem)binaryExpression.getRightExpression());
            }
        } else if (currentExpression instanceof InExpression && (rightItems = (inExp = (InExpression)currentExpression).getRightItemsList()) instanceof SubSelect) {
            this.processSelectBody(((SubSelect)rightItems).getSelectBody());
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), (Expression)appendExpression);
        }
        return new AndExpression(currentExpression, (Expression)appendExpression);
    }

    protected Expression processTableAlias4CustomizedTenantIdExpression(Expression expression, Table table) {
        return expression;
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (null == table.getAlias()) {
            column.append(table.getName());
        } else {
            column.append(table.getAlias().getName());
        }
        column.append(".");
        column.append(this.tenantHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    public TenantHandler getTenantHandler() {
        return this.tenantHandler;
    }

    public TenantSqlParser setTenantHandler(TenantHandler tenantHandler) {
        this.tenantHandler = tenantHandler;
        return this;
    }

    public String toString() {
        return "TenantSqlParser(tenantHandler=" + this.getTenantHandler() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantSqlParser)) {
            return false;
        }
        TenantSqlParser other = (TenantSqlParser)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantHandler this$tenantHandler = this.getTenantHandler();
        TenantHandler other$tenantHandler = other.getTenantHandler();
        return !(this$tenantHandler == null ? other$tenantHandler != null : !this$tenantHandler.equals(other$tenantHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantSqlParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TenantHandler $tenantHandler = this.getTenantHandler();
        result = result * 59 + ($tenantHandler == null ? 43 : $tenantHandler.hashCode());
        return result;
    }
}

