/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.registry;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginLoader;
import org.apache.dolphinscheduler.spi.plugin.DolphinPluginManagerConfig;
import org.apache.dolphinscheduler.spi.register.Registry;
import org.apache.dolphinscheduler.spi.register.RegistryConnectListener;
import org.apache.dolphinscheduler.spi.register.RegistryException;
import org.apache.dolphinscheduler.spi.register.RegistryPluginManager;
import org.apache.dolphinscheduler.spi.register.SubscribeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryCenter {
    private static final Logger logger = LoggerFactory.getLogger(RegistryCenter.class);
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private Registry registry;
    private IStoppable stoppable;
    protected static String NODES;
    private RegistryPluginManager registryPluginManager;
    protected static final String EMPTY = "";
    private static final String REGISTRY_PREFIX = "registry";
    private static final String REGISTRY_PLUGIN_BINDING = "registry.plugin.binding";
    private static final String REGISTRY_PLUGIN_DIR = "registry.plugin.dir";
    private static final String MAVEN_LOCAL_REPOSITORY = "maven.local.repository";
    private static final String REGISTRY_PLUGIN_NAME = "plugin.name";
    private static final String REGISTRY_PLUGIN_PATH = "lib/plugin/registry";
    private static final String REGISTRY_CONFIG_FILE_PATH = "/registry.properties";

    public void init() {
        if (this.isStarted.compareAndSet(false, true)) {
            PropertyUtils.loadPropertyFile((String[])new String[]{REGISTRY_CONFIG_FILE_PATH});
            Map registryConfig = PropertyUtils.getPropertiesByPrefix((String)REGISTRY_PREFIX);
            if (null == registryConfig || registryConfig.isEmpty()) {
                throw new RegistryException("registry config param is null");
            }
            if (null == this.registryPluginManager) {
                this.installRegistryPlugin((String)registryConfig.get(REGISTRY_PLUGIN_NAME));
                this.registry = this.registryPluginManager.getRegistry();
            }
            this.registry.init(registryConfig);
            this.initNodes();
        }
    }

    private void initNodes() {
        this.persist("/nodes/master", EMPTY);
        this.persist("/nodes/worker", EMPTY);
        this.persist("/dead-servers", EMPTY);
    }

    private void installRegistryPlugin(String registryPluginName) {
        DolphinPluginManagerConfig registryPluginManagerConfig = new DolphinPluginManagerConfig();
        registryPluginManagerConfig.setPlugins(PropertyUtils.getString((String)REGISTRY_PLUGIN_BINDING));
        if (StringUtils.isNotBlank((String)PropertyUtils.getString((String)REGISTRY_PLUGIN_DIR))) {
            registryPluginManagerConfig.setInstalledPluginsDir(PropertyUtils.getString((String)REGISTRY_PLUGIN_DIR, (String)REGISTRY_PLUGIN_PATH).trim());
        }
        if (StringUtils.isNotBlank((String)PropertyUtils.getString((String)MAVEN_LOCAL_REPOSITORY))) {
            registryPluginManagerConfig.setMavenLocalRepository(PropertyUtils.getString((String)MAVEN_LOCAL_REPOSITORY).trim());
        }
        this.registryPluginManager = new RegistryPluginManager(registryPluginName);
        DolphinPluginLoader registryPluginLoader = new DolphinPluginLoader(registryPluginManagerConfig, (List)ImmutableList.of((Object)this.registryPluginManager));
        try {
            registryPluginLoader.loadPlugins();
        }
        catch (Exception e) {
            throw new RuntimeException("Load registry Plugin Failed !", e);
        }
    }

    public void close() {
        if (this.isStarted.compareAndSet(true, false) && this.registry != null) {
            this.registry.close();
        }
    }

    public void persist(String key, String value) {
        this.registry.persist(key, value);
    }

    public void persistEphemeral(String key, String value) {
        this.registry.persistEphemeral(key, value);
    }

    public void remove(String key) {
        this.registry.remove(key);
    }

    public void update(String key, String value) {
        this.registry.update(key, value);
    }

    public String get(String key) {
        return this.registry.get(key);
    }

    public void subscribe(String path, SubscribeListener subscribeListener) {
        this.registry.subscribe(path, subscribeListener);
    }

    public void addConnectionStateListener(RegistryConnectListener registryConnectListener) {
        this.registry.addConnectionStateListener(registryConnectListener);
    }

    public boolean isExisted(String key) {
        return this.registry.isExisted(key);
    }

    public boolean getLock(String key) {
        return this.registry.acquireLock(key);
    }

    public boolean releaseLock(String key) {
        return this.registry.releaseLock(key);
    }

    public String getDeadZNodeParentPath() {
        return "/dead-servers";
    }

    public void setStoppable(IStoppable stoppable) {
        this.stoppable = stoppable;
    }

    public IStoppable getStoppable() {
        return this.stoppable;
    }

    public boolean isMasterPath(String path) {
        return path != null && path.contains("/nodes/master");
    }

    public String getWorkerGroupPath(String workerGroup) {
        return "/nodes/worker/" + workerGroup;
    }

    public boolean isWorkerPath(String path) {
        return path != null && path.contains("/nodes/worker");
    }

    public List<String> getChildrenKeys(String key) {
        return this.registry.getChildren(key);
    }
}

