/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.quartz.cron;

import com.cronutils.model.Cron;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.QuestionMark;
import org.apache.dolphinscheduler.common.enums.CycleEnum;
import org.apache.dolphinscheduler.service.quartz.cron.AbstractCycle;

public class CycleFactory {
    private CycleFactory() {
        throw new IllegalStateException("CycleFactory class");
    }

    public static AbstractCycle min(Cron cron) {
        return new MinCycle(cron);
    }

    public static AbstractCycle hour(Cron cron) {
        return new HourCycle(cron);
    }

    public static AbstractCycle day(Cron cron) {
        return new DayCycle(cron);
    }

    public static AbstractCycle week(Cron cron) {
        return new WeekCycle(cron);
    }

    public static AbstractCycle month(Cron cron) {
        return new MonthCycle(cron);
    }

    public static class WeekCycle
    extends AbstractCycle {
        public WeekCycle(Cron cron) {
            super(cron);
        }

        @Override
        protected CycleEnum getCycle() {
            if (this.minFiledIsSetAll() && this.hourFiledIsSetAll() && this.dayOfMonthField.getExpression() instanceof QuestionMark && this.dayofWeekFieldIsEvery() && this.monthField.getExpression() instanceof Always) {
                return CycleEnum.WEEK;
            }
            return null;
        }

        @Override
        protected CycleEnum getMiniCycle() {
            if (this.dayofWeekFieldIsEvery()) {
                return CycleEnum.WEEK;
            }
            return null;
        }
    }

    public static class MonthCycle
    extends AbstractCycle {
        public MonthCycle(Cron cron) {
            super(cron);
        }

        @Override
        protected CycleEnum getCycle() {
            boolean flag;
            boolean bl = flag = this.minFiledIsSetAll() && this.hourFiledIsSetAll() && this.dayOfMonthFieldIsSetAll() && this.dayOfWeekField.getExpression() instanceof QuestionMark && this.monthFieldIsEvery() || this.minFiledIsSetAll() && this.hourFiledIsSetAll() && this.dayOfMonthField.getExpression() instanceof QuestionMark && this.dayofWeekFieldIsSetAll() && this.monthFieldIsEvery();
            if (flag) {
                return CycleEnum.MONTH;
            }
            return null;
        }

        @Override
        protected CycleEnum getMiniCycle() {
            if (this.monthFieldIsEvery()) {
                return CycleEnum.MONTH;
            }
            return null;
        }
    }

    public static class MinCycle
    extends AbstractCycle {
        public MinCycle(Cron cron) {
            super(cron);
        }

        @Override
        protected CycleEnum getCycle() {
            if (this.minFiledIsEvery() && this.hourField.getExpression() instanceof Always && this.dayOfMonthField.getExpression() instanceof Always && this.monthField.getExpression() instanceof Always) {
                return CycleEnum.MINUTE;
            }
            return null;
        }

        @Override
        protected CycleEnum getMiniCycle() {
            if (this.minFiledIsEvery()) {
                return CycleEnum.MINUTE;
            }
            return null;
        }
    }

    public static class HourCycle
    extends AbstractCycle {
        public HourCycle(Cron cron) {
            super(cron);
        }

        @Override
        protected CycleEnum getCycle() {
            if (this.minFiledIsSetAll() && this.hourFiledIsEvery() && this.dayOfMonthField.getExpression() instanceof Always && this.dayOfWeekField.getExpression() instanceof QuestionMark && this.monthField.getExpression() instanceof Always) {
                return CycleEnum.HOUR;
            }
            return null;
        }

        @Override
        protected CycleEnum getMiniCycle() {
            if (this.hourFiledIsEvery()) {
                return CycleEnum.HOUR;
            }
            return null;
        }
    }

    public static class DayCycle
    extends AbstractCycle {
        public DayCycle(Cron cron) {
            super(cron);
        }

        @Override
        protected CycleEnum getCycle() {
            if (this.minFiledIsSetAll() && this.hourFiledIsSetAll() && this.dayOfMonthFieldIsEvery() && this.dayOfWeekField.getExpression() instanceof QuestionMark && this.monthField.getExpression() instanceof Always) {
                return CycleEnum.DAY;
            }
            return null;
        }

        @Override
        protected CycleEnum getMiniCycle() {
            if (this.dayOfMonthFieldIsEvery()) {
                return CycleEnum.DAY;
            }
            return null;
        }
    }
}

