/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.email;

import com.sun.mail.smtp.SMTPProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.dolphinscheduler.plugin.alert.email.ExcelUtils;
import org.apache.dolphinscheduler.plugin.alert.email.exception.AlertEmailException;
import org.apache.dolphinscheduler.plugin.alert.email.template.AlertTemplate;
import org.apache.dolphinscheduler.plugin.alert.email.template.DefaultHTMLTemplate;
import org.apache.dolphinscheduler.spi.alert.AlertResult;
import org.apache.dolphinscheduler.spi.alert.ShowType;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSender {
    public static final Logger logger = LoggerFactory.getLogger(MailSender.class);
    private List<String> receivers;
    private List<String> receiverCcs;
    private String mailProtocol = "SMTP";
    private String mailSmtpHost;
    private String mailSmtpPort;
    private String mailSenderEmail;
    private String enableSmtpAuth;
    private String mailUser;
    private String mailPasswd;
    private String mailUseStartTLS;
    private String mailUseSSL;
    private String xlsFilePath;
    private String sslTrust;
    private String showType;
    private AlertTemplate alertTemplate;
    private String mustNotNull = " must not be null";

    public MailSender(Map<String, String> config) {
        String receiversConfig = config.get("receivers");
        if (receiversConfig == null || "".equals(receiversConfig)) {
            throw new AlertEmailException("$t('receivers')" + this.mustNotNull);
        }
        this.receivers = Arrays.asList(receiversConfig.split(","));
        String receiverCcsConfig = config.get("receiverCcs");
        this.receiverCcs = new ArrayList<String>();
        if (receiverCcsConfig != null && !"".equals(receiverCcsConfig)) {
            this.receiverCcs = Arrays.asList(receiverCcsConfig.split(","));
        }
        this.mailSmtpHost = config.get("serverHost");
        Objects.requireNonNull(this.mailSmtpHost, "mail.smtp.host" + this.mustNotNull);
        this.mailSmtpPort = config.get("serverPort");
        Objects.requireNonNull(this.mailSmtpPort, "mail.smtp.port" + this.mustNotNull);
        this.mailSenderEmail = config.get("sender");
        Objects.requireNonNull(this.mailSenderEmail, "mail.sender" + this.mustNotNull);
        this.enableSmtpAuth = config.get("enableSmtpAuth");
        this.mailUser = config.get("user");
        Objects.requireNonNull(this.mailUser, "mail.user" + this.mustNotNull);
        this.mailPasswd = config.get("passwd");
        Objects.requireNonNull(this.mailPasswd, "mail.passwd" + this.mustNotNull);
        this.mailUseStartTLS = config.get("starttlsEnable");
        Objects.requireNonNull(this.mailUseStartTLS, "mail.smtp.starttls.enable" + this.mustNotNull);
        this.mailUseSSL = config.get("sslEnable");
        Objects.requireNonNull(this.mailUseSSL, "mail.smtp.ssl.enable" + this.mustNotNull);
        this.sslTrust = config.get("smtpSslTrust");
        Objects.requireNonNull(this.sslTrust, "mail.smtp.ssl.trust" + this.mustNotNull);
        this.showType = config.get("show_type");
        Objects.requireNonNull(this.showType, "show_type" + this.mustNotNull);
        this.xlsFilePath = config.get("xls.file.path");
        if (StringUtils.isBlank((CharSequence)this.xlsFilePath)) {
            this.xlsFilePath = "/tmp/xls";
        }
        this.alertTemplate = new DefaultHTMLTemplate();
    }

    public AlertResult sendMails(String title, String content) {
        return this.sendMails(this.receivers, this.receiverCcs, title, content);
    }

    public AlertResult sendMailsToReceiverOnly(String title, String content) {
        return this.sendMails(this.receivers, null, title, content);
    }

    public AlertResult sendMails(List<String> receivers, List<String> receiverCcs, String title, String content) {
        AlertResult alertResult = new AlertResult();
        alertResult.setStatus("false");
        if (CollectionUtils.isEmpty(receivers) && CollectionUtils.isEmpty(receiverCcs)) {
            return alertResult;
        }
        receivers.removeIf(StringUtils::isEmpty);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        if (this.showType.equals(ShowType.TABLE.getDescp()) || this.showType.equals(ShowType.TEXT.getDescp())) {
            HtmlEmail email = new HtmlEmail();
            try {
                Session session = this.getSession();
                email.setMailSession(session);
                email.setFrom(this.mailSenderEmail);
                email.setCharset("UTF-8");
                if (CollectionUtils.isNotEmpty(receivers)) {
                    for (String receiver : receivers) {
                        email.addTo(receiver);
                    }
                }
                if (CollectionUtils.isNotEmpty(receiverCcs)) {
                    for (String receiverCc : receiverCcs) {
                        email.addCc(receiverCc);
                    }
                }
                return this.getStringObjectMap(title, content, alertResult, email);
            }
            catch (Exception e) {
                this.handleException(alertResult, e);
            }
        } else if (this.showType.equals(ShowType.ATTACHMENT.getDescp()) || this.showType.equals(ShowType.TABLEATTACHMENT.getDescp())) {
            try {
                String partContent = this.showType.equals(ShowType.ATTACHMENT.getDescp()) ? "Please see the attachment " + title + ".xlsx" : this.htmlTable(content, false);
                this.attachment(title, content, partContent);
                alertResult.setStatus("true");
                return alertResult;
            }
            catch (Exception e) {
                this.handleException(alertResult, e);
                return alertResult;
            }
        }
        return alertResult;
    }

    private String htmlTable(String content, boolean showAll) {
        return this.alertTemplate.getMessageFromTemplate(content, ShowType.TABLE, showAll);
    }

    private String htmlTable(String content) {
        return this.htmlTable(content, true);
    }

    private String htmlText(String content) {
        return this.alertTemplate.getMessageFromTemplate(content, ShowType.TEXT);
    }

    private void attachment(String title, String content, String partContent) throws Exception {
        MimeMessage msg = this.getMimeMessage();
        this.attachContent(title, content, partContent, msg);
    }

    private MimeMessage getMimeMessage() throws MessagingException {
        Session session = this.getSession();
        session.setDebug(false);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(this.mailSenderEmail));
        for (String receiver : this.receivers) {
            msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)receiver));
        }
        return msg;
    }

    private Session getSession() {
        MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
        mc.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
        mc.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
        mc.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
        mc.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
        CommandMap.setDefaultCommandMap((CommandMap)mc);
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.mailSmtpHost);
        props.setProperty("mail.smtp.port", this.mailSmtpPort);
        props.setProperty("mail.smtp.auth", this.enableSmtpAuth);
        props.setProperty("mail.transport.protocol", this.mailProtocol);
        props.setProperty("mail.smtp.starttls.enable", this.mailUseStartTLS);
        props.setProperty("mail.smtp.ssl.enable", this.mailUseSSL);
        props.setProperty("mail.smtp.ssl.trust", this.sslTrust);
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailSender.this.mailUser, MailSender.this.mailPasswd);
            }
        };
        Session session = Session.getInstance((Properties)props, (Authenticator)auth);
        session.addProvider((Provider)new SMTPProvider());
        return session;
    }

    private void attachContent(String title, String content, String partContent, MimeMessage msg) throws MessagingException, IOException {
        if (CollectionUtils.isNotEmpty(this.receiverCcs)) {
            for (String receiverCc : this.receiverCcs) {
                msg.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)receiverCc));
            }
        }
        msg.setSubject(title);
        MimeMultipart partList = new MimeMultipart();
        MimeBodyPart part1 = new MimeBodyPart();
        part1.setContent((Object)partContent, "text/html;charset=utf-8");
        MimeBodyPart part2 = new MimeBodyPart();
        File file = new File(this.xlsFilePath + "/" + title + ".xlsx");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        ExcelUtils.genExcelFile(content, title, this.xlsFilePath);
        part2.attachFile(file);
        part2.setFileName(MimeUtility.encodeText((String)(title + ".xlsx"), (String)"UTF-8", (String)"B"));
        partList.addBodyPart((BodyPart)part1);
        partList.addBodyPart((BodyPart)part2);
        msg.setContent((Multipart)partList);
        Transport.send((Message)msg);
        this.deleteFile(file);
    }

    private AlertResult getStringObjectMap(String title, String content, AlertResult alertResult, HtmlEmail email) throws EmailException {
        email.setSubject(title);
        if (this.showType.equals(ShowType.TABLE.getDescp())) {
            email.setMsg(this.htmlTable(content));
        } else if (this.showType.equals(ShowType.TEXT.getDescp())) {
            email.setMsg(this.htmlText(content));
        }
        email.setDebug(true);
        email.send();
        alertResult.setStatus("true");
        return alertResult;
    }

    public void deleteFile(File file) {
        if (file.exists()) {
            if (file.delete()) {
                logger.info("delete success: {}", (Object)file.getAbsolutePath());
            } else {
                logger.info("delete fail: {}", (Object)file.getAbsolutePath());
            }
        } else {
            logger.info("file not exists: {}", (Object)file.getAbsolutePath());
        }
    }

    private void handleException(AlertResult alertResult, Exception e) {
        logger.error("Send email to {} failed", this.receivers, (Object)e);
        alertResult.setMessage("Send email to {" + String.join((CharSequence)",", this.receivers) + "} failed\uff0c" + e.toString());
    }
}

