/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.alert.email;

import java.util.Map;
import org.apache.dolphinscheduler.plugin.alert.email.MailSender;
import org.apache.dolphinscheduler.spi.alert.AlertChannel;
import org.apache.dolphinscheduler.spi.alert.AlertData;
import org.apache.dolphinscheduler.spi.alert.AlertInfo;
import org.apache.dolphinscheduler.spi.alert.AlertResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAlertChannel
implements AlertChannel {
    private static final Logger logger = LoggerFactory.getLogger(EmailAlertChannel.class);

    public AlertResult process(AlertInfo info) {
        AlertData alert = info.getAlertData();
        Map paramsMap = info.getAlertParams();
        if (null == paramsMap) {
            return new AlertResult("false", "mail params is null");
        }
        MailSender mailSender = new MailSender(paramsMap);
        AlertResult alertResult = mailSender.sendMails(alert.getTitle(), alert.getContent());
        boolean flag = false;
        if (alertResult == null) {
            alertResult = new AlertResult();
            alertResult.setStatus("false");
            alertResult.setMessage("alert send error.");
            logger.info("alert send error : {}", (Object)alertResult.getMessage());
            return alertResult;
        }
        flag = Boolean.parseBoolean(String.valueOf(alertResult.getStatus()));
        if (flag) {
            logger.info("alert send success");
            alertResult.setMessage("email send success.");
        } else {
            alertResult.setMessage("alert send error.");
            logger.info("alert send error : {}", (Object)alertResult.getMessage());
        }
        return alertResult;
    }
}

