/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectDao {
    public static final Logger logger = LoggerFactory.getLogger(ProjectDao.class);

    public Map<Integer, Long> queryAllProject(Connection conn) {
        HashMap<Integer, Long> projectMap = new HashMap<Integer, Long>();
        String sql = "SELECT id,code FROM t_ds_project";
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer id = rs.getInt(1);
                long code = rs.getLong(2);
                if (code == 0L) {
                    code = CodeGenerateUtils.getInstance().genCode();
                }
                projectMap.put(id, code);
            }
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        return projectMap;
    }

    public void updateProjectCode(Connection conn, Map<Integer, Long> projectMap) {
        String sql = "UPDATE t_ds_project SET code=? where id=?";
        try {
            for (Map.Entry<Integer, Long> entry : projectMap.entrySet()) {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    pstmt.setLong(1, entry.getValue());
                    pstmt.setInt(2, entry.getKey());
                    pstmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
    }
}

