/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.upgrade;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.ReleaseState;
import org.apache.dolphinscheduler.common.utils.CodeGenerateUtils;
import org.apache.dolphinscheduler.common.utils.ConnectionUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinitionDao {
    public static final Logger logger = LoggerFactory.getLogger(ProcessDefinitionDao.class);

    public Map<Integer, String> queryAllProcessDefinition(Connection conn) {
        HashMap<Integer, String> processDefinitionJsonMap = new HashMap<Integer, String>();
        String sql = "SELECT id,process_definition_json FROM t_ds_process_definition";
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Integer id = rs.getInt(1);
                String processDefinitionJson = rs.getString(2);
                processDefinitionJsonMap.put(id, processDefinitionJson);
            }
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        return processDefinitionJsonMap;
    }

    public void updateProcessDefinitionJson(Connection conn, Map<Integer, String> processDefinitionJsonMap) {
        String sql = "UPDATE t_ds_process_definition SET process_definition_json=? where id=?";
        try {
            for (Map.Entry<Integer, String> entry : processDefinitionJsonMap.entrySet()) {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    pstmt.setString(1, entry.getValue());
                    pstmt.setInt(2, entry.getKey());
                    pstmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
    }

    public List<ProcessDefinition> queryProcessDefinition(Connection conn) {
        ArrayList<ProcessDefinition> processDefinitions = new ArrayList<ProcessDefinition>();
        String sql = "SELECT id,code,project_code,user_id,locations,name,description,release_state,flag,create_time FROM t_ds_process_definition";
        ResultSet rs = null;
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ProcessDefinition processDefinition = new ProcessDefinition();
                processDefinition.setId(rs.getInt(1));
                long code = rs.getLong(2);
                if (code == 0L) {
                    code = CodeGenerateUtils.getInstance().genCode();
                }
                processDefinition.setCode(code);
                processDefinition.setVersion(1);
                processDefinition.setProjectCode(rs.getLong(3));
                processDefinition.setUserId(rs.getInt(4));
                processDefinition.setLocations(rs.getString(5));
                processDefinition.setName(rs.getString(6));
                processDefinition.setDescription(rs.getString(7));
                processDefinition.setReleaseState(ReleaseState.getEnum((int)rs.getInt(8)));
                processDefinition.setFlag(rs.getInt(9) == 1 ? Flag.YES : Flag.NO);
                processDefinition.setCreateTime(rs.getDate(10));
                processDefinitions.add(processDefinition);
            }
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{rs, pstmt, conn});
        return processDefinitions;
    }

    public void updateProcessDefinitionCode(Connection conn, List<ProcessDefinition> processDefinitions, Map<Integer, Long> projectIdCodeMap) {
        String sql = "UPDATE t_ds_process_definition SET code=?, project_code=?, version=? where id=?";
        try {
            for (ProcessDefinition processDefinition : processDefinitions) {
                PreparedStatement pstmt = conn.prepareStatement(sql);
                Throwable throwable = null;
                try {
                    Integer projectId;
                    pstmt.setLong(1, processDefinition.getCode());
                    long projectCode = processDefinition.getProjectCode();
                    if (String.valueOf(projectCode).length() <= 10 && projectIdCodeMap.containsKey(projectId = Integer.valueOf(Integer.parseInt(String.valueOf(projectCode))))) {
                        projectCode = projectIdCodeMap.get(projectId);
                        processDefinition.setProjectCode(projectCode);
                    }
                    pstmt.setLong(2, projectCode);
                    pstmt.setInt(3, processDefinition.getVersion());
                    pstmt.setInt(4, processDefinition.getId());
                    pstmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (pstmt == null) continue;
                    if (throwable != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    pstmt.close();
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException("sql: " + sql, e);
            }
            catch (Throwable throwable) {
                ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        ConnectionUtils.releaseResource((AutoCloseable[])new AutoCloseable[]{conn});
    }
}

