/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.dolphinscheduler.dao.datasource.SpringConnectionFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionFactory
extends SpringConnectionFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private SqlSessionFactory sqlSessionFactory;
    private SqlSessionTemplate sqlSessionTemplate;
    private DataSource dataSource;

    public static ConnectionFactory getInstance() {
        return ConnectionFactoryHolder.connectionFactory;
    }

    private ConnectionFactory() {
        try {
            this.dataSource = this.buildDataSource();
            this.sqlSessionFactory = this.getSqlSessionFactory();
            this.sqlSessionTemplate = this.getSqlSessionTemplate();
        }
        catch (Exception e) {
            logger.error("Initializing ConnectionFactory error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private DataSource buildDataSource() throws SQLException {
        DruidDataSource druidDataSource = this.dataSource();
        return druidDataSource;
    }

    private SqlSessionFactory getSqlSessionFactory() throws Exception {
        JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment environment = new Environment("development", (TransactionFactory)transactionFactory, this.getDataSource());
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setEnvironment(environment);
        configuration.setLazyLoadingEnabled(true);
        configuration.addMappers("org.apache.dolphinscheduler.dao.mapper");
        configuration.addInterceptor((Interceptor)new PaginationInterceptor());
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setConfiguration(configuration);
        sqlSessionFactoryBean.setDataSource(this.getDataSource());
        sqlSessionFactoryBean.setTypeEnumsPackage("org.apache.dolphinscheduler.*.enums");
        this.sqlSessionFactory = sqlSessionFactoryBean.getObject();
        return this.sqlSessionFactory;
    }

    private SqlSessionTemplate getSqlSessionTemplate() {
        this.sqlSessionTemplate = new SqlSessionTemplate(this.sqlSessionFactory);
        return this.sqlSessionTemplate;
    }

    public SqlSession getSqlSession() {
        return this.sqlSessionTemplate;
    }

    public <T> T getMapper(Class<T> type) {
        try {
            return (T)this.getSqlSession().getMapper(type);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("get mapper failed");
        }
    }

    private static class ConnectionFactoryHolder {
        private static final ConnectionFactory connectionFactory = new ConnectionFactory();

        private ConnectionFactoryHolder() {
        }
    }
}

