/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.dolphinscheduler.common.enums.AlertEvent;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.enums.AlertWarnLevel;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.AbstractBaseDao;
import org.apache.dolphinscheduler.dao.datasource.ConnectionFactory;
import org.apache.dolphinscheduler.dao.entity.Alert;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.dao.entity.ProcessAlertContent;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.ServerAlertContent;
import org.apache.dolphinscheduler.dao.mapper.AlertGroupMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertMapper;
import org.apache.dolphinscheduler.dao.mapper.AlertPluginInstanceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlertDao
extends AbstractBaseDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AlertMapper alertMapper;
    @Autowired
    private AlertPluginInstanceMapper alertPluginInstanceMapper;
    @Autowired
    private AlertGroupMapper alertGroupMapper;

    @Override
    protected void init() {
        this.alertMapper = ConnectionFactory.getInstance().getMapper(AlertMapper.class);
        this.alertPluginInstanceMapper = ConnectionFactory.getInstance().getMapper(AlertPluginInstanceMapper.class);
        this.alertGroupMapper = ConnectionFactory.getInstance().getMapper(AlertGroupMapper.class);
    }

    public int addAlert(Alert alert) {
        return this.alertMapper.insert(alert);
    }

    public int updateAlert(AlertStatus alertStatus, String log, int id) {
        Alert alert = (Alert)this.alertMapper.selectById(Integer.valueOf(id));
        alert.setAlertStatus(alertStatus);
        alert.setUpdateTime(new Date());
        alert.setLog(log);
        return this.alertMapper.updateById(alert);
    }

    public void sendServerStopedAlert(int alertGroupId, String host, String serverType) {
        ServerAlertContent serverStopAlertContent = ServerAlertContent.newBuilder().type(serverType).host(host).event(AlertEvent.SERVER_DOWN).warningLevel(AlertWarnLevel.SERIOUS).build();
        String content = JSONUtils.toJsonString((Object)Lists.newArrayList((Object[])new ServerAlertContent[]{serverStopAlertContent}));
        Alert alert = new Alert();
        alert.setTitle("Fault tolerance warning");
        alert.setAlertStatus(AlertStatus.WAIT_EXECUTION);
        alert.setContent(content);
        alert.setAlertGroupId(alertGroupId);
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        this.alertMapper.insertAlertWhenServerCrash(alert);
    }

    public void sendProcessTimeoutAlert(ProcessInstance processInstance, ProcessDefinition processDefinition) {
        int alertGroupId = processInstance.getWarningGroupId();
        Alert alert = new Alert();
        ArrayList<ProcessAlertContent> processAlertContentList = new ArrayList<ProcessAlertContent>(1);
        ProcessAlertContent processAlertContent = ProcessAlertContent.newBuilder().processId(processInstance.getId()).processName(processInstance.getName()).event(AlertEvent.TIME_OUT).warningLevel(AlertWarnLevel.MIDDLE).build();
        processAlertContentList.add(processAlertContent);
        String content = JSONUtils.toJsonString(processAlertContentList);
        alert.setTitle("Process Timeout Warn");
        this.saveTaskTimeoutAlert(alert, content, alertGroupId);
    }

    private void saveTaskTimeoutAlert(Alert alert, String content, int alertGroupId) {
        alert.setAlertGroupId(alertGroupId);
        alert.setContent(content);
        alert.setCreateTime(new Date());
        alert.setUpdateTime(new Date());
        this.alertMapper.insert(alert);
    }

    public void sendTaskTimeoutAlert(int alertGroupId, int processInstanceId, String processInstanceName, int taskId, String taskName) {
        Alert alert = new Alert();
        ArrayList<ProcessAlertContent> processAlertContentList = new ArrayList<ProcessAlertContent>(1);
        ProcessAlertContent processAlertContent = ProcessAlertContent.newBuilder().processId(processInstanceId).processName(processInstanceName).taskId(taskId).taskName(taskName).event(AlertEvent.TIME_OUT).warningLevel(AlertWarnLevel.MIDDLE).build();
        processAlertContentList.add(processAlertContent);
        String content = JSONUtils.toJsonString(processAlertContentList);
        alert.setTitle("Task Timeout Warn");
        this.saveTaskTimeoutAlert(alert, content, alertGroupId);
    }

    public List<Alert> listWaitExecutionAlert() {
        return this.alertMapper.listAlertByStatus(AlertStatus.WAIT_EXECUTION);
    }

    public AlertMapper getAlertMapper() {
        return this.alertMapper;
    }

    public List<AlertPluginInstance> listInstanceByAlertGroupId(int alertGroupId) {
        String alertInstanceIdsParam = this.alertGroupMapper.queryAlertGroupInstanceIdsById(alertGroupId);
        if (StringUtils.isNotBlank((String)alertInstanceIdsParam)) {
            String[] idsArray = alertInstanceIdsParam.split(",");
            List<Integer> ids = Arrays.stream(idsArray).map(s -> Integer.parseInt(s.trim())).collect(Collectors.toList());
            return this.alertPluginInstanceMapper.queryByIds(ids);
        }
        return null;
    }

    public AlertPluginInstanceMapper getAlertPluginInstanceMapper() {
        return this.alertPluginInstanceMapper;
    }

    public void setAlertPluginInstanceMapper(AlertPluginInstanceMapper alertPluginInstanceMapper) {
        this.alertPluginInstanceMapper = alertPluginInstanceMapper;
    }

    public AlertGroupMapper getAlertGroupMapper() {
        return this.alertGroupMapper;
    }

    public void setAlertGroupMapper(AlertGroupMapper alertGroupMapper) {
        this.alertGroupMapper = alertGroupMapper;
    }
}

