/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.curator.test.TestingServer;
import org.apache.dolphinscheduler.alert.AlertServer;
import org.apache.dolphinscheduler.api.ApiApplicationServer;
import org.apache.dolphinscheduler.common.utils.ScriptRunner;
import org.apache.dolphinscheduler.dao.datasource.ConnectionFactory;
import org.apache.dolphinscheduler.server.master.MasterServer;
import org.apache.dolphinscheduler.server.worker.WorkerServer;
import org.h2.Driver;
import org.h2.tools.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;

@SpringBootApplication
public class StandaloneServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandaloneServer.class);

    public static void main(String[] args) throws Exception {
        Thread.currentThread().setName("Standalone-Server");
        System.setProperty("spring.profiles.active", "api");
        StandaloneServer.startDatabase();
        StandaloneServer.startRegistry();
        StandaloneServer.startAlertServer();
        StandaloneServer.setTaskPlugin();
        new SpringApplicationBuilder(new Class[]{ApiApplicationServer.class, MasterServer.class, WorkerServer.class}).run(args);
    }

    private static void startAlertServer() {
        Path alertPluginPath = Paths.get(StandaloneServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "../../../dolphinscheduler-alert-plugin/dolphinscheduler-alert-email/pom.xml").toAbsolutePath();
        if (Files.exists(alertPluginPath, new LinkOption[0])) {
            System.setProperty("alert.plugin.binding", alertPluginPath.toString());
            System.setProperty("alert.plugin.dir", "");
        }
        AlertServer.getInstance().start();
    }

    private static void startRegistry() throws Exception {
        TestingServer server = new TestingServer(true);
        System.setProperty("registry.servers", server.getConnectString());
        Path registryPath = Paths.get(StandaloneServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "../../../dolphinscheduler-registry-plugin/dolphinscheduler-registry-zookeeper/pom.xml").toAbsolutePath();
        if (Files.exists(registryPath, new LinkOption[0])) {
            System.setProperty("registry.plugin.binding", registryPath.toString());
            System.setProperty("registry.plugin.dir", "");
        }
    }

    private static void startDatabase() throws IOException, SQLException {
        Path temp = Files.createTempDirectory("dolphinscheduler_", new FileAttribute[0]);
        LOGGER.info("H2 database directory: {}", (Object)temp);
        System.setProperty("spring.datasource.driver-class-name", Driver.class.getName());
        System.setProperty("spring.datasource.url", String.format("jdbc:h2:tcp://localhost/%s;MODE=MySQL;DATABASE_TO_LOWER=true", temp.toAbsolutePath()));
        System.setProperty("spring.datasource.username", "sa");
        System.setProperty("spring.datasource.password", "");
        Server.createTcpServer((String[])new String[]{"-ifNotExists", "-tcpDaemon"}).start();
        DataSource ds = ConnectionFactory.getInstance().getDataSource();
        ScriptRunner runner = new ScriptRunner(ds.getConnection(), true, true);
        runner.runScript((Reader)new FileReader("sql/dolphinscheduler_h2.sql"));
    }

    private static void setTaskPlugin() {
        Path taskPluginPath = Paths.get(StandaloneServer.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "../../../dolphinscheduler-task-plugin/dolphinscheduler-task-shell/pom.xml").toAbsolutePath();
        if (Files.exists(taskPluginPath, new LinkOption[0])) {
            System.setProperty("task.plugin.binding", taskPluginPath.toString());
            System.setProperty("task.plugin.dir", "");
        }
    }
}

