/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.api;

import org.apache.dolphinscheduler.plugin.task.api.AbstractTaskExecutor;
import org.apache.dolphinscheduler.plugin.task.api.ShellCommandExecutor;
import org.apache.dolphinscheduler.plugin.task.api.TaskResponse;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;

public abstract class AbstractYarnTask
extends AbstractTaskExecutor {
    private ShellCommandExecutor shellCommandExecutor;

    public AbstractYarnTask(TaskRequest taskRequest) {
        super(taskRequest);
        this.shellCommandExecutor = new ShellCommandExecutor(this::logHandle, taskRequest, this.logger);
    }

    public void handle() throws Exception {
        try {
            TaskResponse response = this.shellCommandExecutor.run(this.buildCommand());
            this.setExitStatusCode(response.getExitStatusCode());
            this.setAppIds(response.getAppIds());
            this.setProcessId(response.getProcessId());
        }
        catch (Exception e) {
            this.logger.error("yarn process failure", (Throwable)e);
            this.exitStatusCode = -1;
            throw e;
        }
    }

    public void cancelApplication(boolean status) throws Exception {
        this.cancel = true;
        this.shellCommandExecutor.cancelApplication();
    }

    protected abstract String buildCommand();

    protected abstract void setMainJarName();
}

