/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.mr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.mr.MapReduceArgsUtils;
import org.apache.dolphinscheduler.plugin.task.mr.MapReduceParameters;
import org.apache.dolphinscheduler.plugin.task.mr.ProgramType;
import org.apache.dolphinscheduler.plugin.task.util.MapUtils;
import org.apache.dolphinscheduler.spi.task.AbstractParameters;
import org.apache.dolphinscheduler.spi.task.ResourceInfo;
import org.apache.dolphinscheduler.spi.task.paramparser.ParamUtils;
import org.apache.dolphinscheduler.spi.task.paramparser.ParameterUtils;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;

public class MapReduceTask
extends AbstractYarnTask {
    private static final String MAPREDUCE_COMMAND = "hadoop";
    private MapReduceParameters mapreduceParameters;
    private TaskRequest taskExecutionContext;

    public MapReduceTask(TaskRequest taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.logger.info("mapreduce task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.mapreduceParameters = (MapReduceParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), MapReduceParameters.class));
        if (this.mapreduceParameters == null || !this.mapreduceParameters.checkParameters()) {
            throw new RuntimeException("mapreduce task params is not valid");
        }
        this.mapreduceParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
        HashMap paramsMap = ParamUtils.convert((TaskRequest)this.taskExecutionContext, (AbstractParameters)this.getParameters());
        if (MapUtils.isEmpty((Map)paramsMap)) {
            paramsMap = new HashMap();
        }
        if (MapUtils.isNotEmpty((Map)this.taskExecutionContext.getParamsMap())) {
            paramsMap.putAll(this.taskExecutionContext.getParamsMap());
        }
        String args = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getMainArgs(), (Map)ParamUtils.convert(paramsMap));
        this.mapreduceParameters.setMainArgs(args);
        if (this.mapreduceParameters.getProgramType() != null && this.mapreduceParameters.getProgramType() == ProgramType.PYTHON) {
            String others = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getOthers(), (Map)ParamUtils.convert(paramsMap));
            this.mapreduceParameters.setOthers(others);
        }
    }

    protected String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(MAPREDUCE_COMMAND);
        args.addAll(MapReduceArgsUtils.buildArgs(this.mapreduceParameters));
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), (Map)this.taskExecutionContext.getDefinedParams());
        this.logger.info("mapreduce task command: {}", (Object)command);
        return command;
    }

    protected void setMainJarName() {
        ResourceInfo mainJar = this.mapreduceParameters.getMainJar();
        if (mainJar != null) {
            int resourceId = mainJar.getId();
            String resourceName = resourceId == 0 ? mainJar.getRes() : mainJar.getResourceName().replaceFirst("/", "");
            mainJar.setRes(resourceName);
            this.mapreduceParameters.setMainJar(mainJar);
        }
    }

    public AbstractParameters getParameters() {
        return this.mapreduceParameters;
    }
}

