/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.datasource;

import java.sql.Connection;
import org.apache.dolphinscheduler.plugin.task.datasource.ConnectionParam;
import org.apache.dolphinscheduler.plugin.task.datasource.DatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.clickhouse.ClickHouseDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.db2.Db2DatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.hive.HiveDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.mysql.MysqlDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.oracle.OracleDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.postgresql.PostgreSqlDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.presto.PrestoDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.spark.SparkDatasourceProcessor;
import org.apache.dolphinscheduler.plugin.task.datasource.sqlserver.SqlServerDatasourceProcessor;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceUtil {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceUtil.class);
    private static final DatasourceProcessor mysqlProcessor = new MysqlDatasourceProcessor();
    private static final DatasourceProcessor postgreSqlProcessor = new PostgreSqlDatasourceProcessor();
    private static final DatasourceProcessor hiveProcessor = new HiveDatasourceProcessor();
    private static final DatasourceProcessor sparkProcessor = new SparkDatasourceProcessor();
    private static final DatasourceProcessor clickhouseProcessor = new ClickHouseDatasourceProcessor();
    private static final DatasourceProcessor oracleProcessor = new OracleDatasourceProcessor();
    private static final DatasourceProcessor sqlServerProcessor = new SqlServerDatasourceProcessor();
    private static final DatasourceProcessor db2PROCESSOR = new Db2DatasourceProcessor();
    private static final DatasourceProcessor prestoPROCESSOR = new PrestoDatasourceProcessor();

    private DatasourceUtil() {
    }

    public static ConnectionParam buildConnectionParams(DbType dbType, String connectionJson) {
        return DatasourceUtil.getDatasourceProcessor(dbType).createConnectionParams(connectionJson);
    }

    public static Connection getConnection(DbType dbType, ConnectionParam connectionParam) {
        try {
            return DatasourceUtil.getDatasourceProcessor(dbType).getConnection(connectionParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getJdbcUrl(DbType dbType, ConnectionParam baseConnectionParam) {
        return DatasourceUtil.getDatasourceProcessor(dbType).getJdbcUrl(baseConnectionParam);
    }

    public static DatasourceProcessor getDatasourceProcessor(DbType dbType) {
        switch (dbType) {
            case MYSQL: {
                return mysqlProcessor;
            }
            case POSTGRESQL: {
                return postgreSqlProcessor;
            }
            case HIVE: {
                return hiveProcessor;
            }
            case SPARK: {
                return sparkProcessor;
            }
            case CLICKHOUSE: {
                return clickhouseProcessor;
            }
            case ORACLE: {
                return oracleProcessor;
            }
            case SQLSERVER: {
                return sqlServerProcessor;
            }
            case DB2: {
                return db2PROCESSOR;
            }
            case PRESTO: {
                return prestoPROCESSOR;
            }
        }
        throw new IllegalArgumentException("datasource type illegal:" + dbType);
    }
}

