/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.spark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.spark.SparkArgsUtils;
import org.apache.dolphinscheduler.plugin.task.spark.SparkParameters;
import org.apache.dolphinscheduler.plugin.task.spark.SparkVersion;
import org.apache.dolphinscheduler.plugin.task.util.MapUtils;
import org.apache.dolphinscheduler.spi.task.AbstractParameters;
import org.apache.dolphinscheduler.spi.task.ResourceInfo;
import org.apache.dolphinscheduler.spi.task.paramparser.ParamUtils;
import org.apache.dolphinscheduler.spi.task.paramparser.ParameterUtils;
import org.apache.dolphinscheduler.spi.task.request.TaskRequest;
import org.apache.dolphinscheduler.spi.utils.JSONUtils;

public class SparkTask
extends AbstractYarnTask {
    private static final String SPARK1_COMMAND = "${SPARK_HOME1}/bin/spark-submit";
    private static final String SPARK2_COMMAND = "${SPARK_HOME2}/bin/spark-submit";
    private SparkParameters sparkParameters;
    private TaskRequest taskExecutionContext;

    public SparkTask(TaskRequest taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.logger.info("spark task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.sparkParameters = (SparkParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), SparkParameters.class));
        if (null == this.sparkParameters) {
            this.logger.error("Spark params is null");
            return;
        }
        if (!this.sparkParameters.checkParameters()) {
            throw new RuntimeException("spark task params is not valid");
        }
        this.sparkParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
    }

    protected String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        String sparkCommand = SPARK2_COMMAND;
        if (SparkVersion.SPARK1.name().equals(this.sparkParameters.getSparkVersion())) {
            sparkCommand = SPARK1_COMMAND;
        }
        args.add(sparkCommand);
        args.addAll(SparkArgsUtils.buildArgs(this.sparkParameters));
        HashMap paramsMap = ParamUtils.convert((TaskRequest)this.taskExecutionContext, (AbstractParameters)this.getParameters());
        if (MapUtils.isEmpty((Map)paramsMap)) {
            paramsMap = new HashMap();
        }
        if (MapUtils.isNotEmpty((Map)this.taskExecutionContext.getParamsMap())) {
            paramsMap.putAll(this.taskExecutionContext.getParamsMap());
        }
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), (Map)ParamUtils.convert(paramsMap));
        this.logger.info("spark task command: {}", (Object)command);
        return command;
    }

    protected void setMainJarName() {
        ResourceInfo mainJar = this.sparkParameters.getMainJar();
        if (null == mainJar) {
            throw new RuntimeException("Spark task jar params is null");
        }
        int resourceId = mainJar.getId();
        String resourceName = resourceId == 0 ? mainJar.getRes() : mainJar.getResourceName().replaceFirst("/", "");
        mainJar.setRes(resourceName);
        this.sparkParameters.setMainJar(mainJar);
    }

    public AbstractParameters getParameters() {
        return this.sparkParameters;
    }
}

