/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.dolphinscheduler.spi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final Properties properties = new Properties();

    private PropertyUtils() {
        throw new UnsupportedOperationException("Construct PropertyUtils");
    }

    public static synchronized void loadPropertyFile(String ... propertyFiles) {
        for (String fileName : propertyFiles) {
            try (InputStream fis = PropertyUtils.class.getResourceAsStream(fileName);){
                properties.load(fis);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                System.exit(1);
            }
        }
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = String.valueOf(k);
            logger.info("Overriding property from system property: {}", (Object)key);
            PropertyUtils.setValue(key, String.valueOf(v));
        }));
    }

    public static String getString(String key) {
        return properties.getProperty(key.trim());
    }

    public static String getUpperCaseString(String key) {
        return properties.getProperty(key.trim()).toUpperCase();
    }

    public static String getString(String key, String defaultVal) {
        String val = properties.getProperty(key.trim());
        return val == null ? defaultVal : val;
    }

    public static int getInt(String key) {
        return PropertyUtils.getInt(key, -1);
    }

    public static int getInt(String key, int defaultValue) {
        String value = PropertyUtils.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    public static boolean getBoolean(String key) {
        String value = properties.getProperty(key.trim());
        if (null != value) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public static Boolean getBoolean(String key, boolean defaultValue) {
        String value = properties.getProperty(key.trim());
        if (null != value) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static long getLong(String key, long defaultVal) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultVal : Long.parseLong(val);
    }

    public static long getLong(String key) {
        return PropertyUtils.getLong(key, -1L);
    }

    public static double getDouble(String key, double defaultVal) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultVal : Double.parseDouble(val);
    }

    public static String[] getArray(String key, String splitStr) {
        String value = PropertyUtils.getString(key);
        if (value == null) {
            return new String[0];
        }
        try {
            String[] propertyArray = value.split(splitStr);
            return propertyArray;
        }
        catch (NumberFormatException e) {
            logger.info(e.getMessage(), (Throwable)e);
            return new String[0];
        }
    }

    public static <T extends Enum<T>> T getEnum(String key, Class<T> type, T defaultValue) {
        String val = PropertyUtils.getString(key);
        return val == null ? defaultValue : Enum.valueOf(type, val);
    }

    public static Map<String, String> getPrefixedProperties(String prefix) {
        HashMap<String, String> matchedProperties = new HashMap<String, String>();
        for (String propName : properties.stringPropertyNames()) {
            if (!propName.startsWith(prefix)) continue;
            matchedProperties.put(propName, properties.getProperty(propName));
        }
        return matchedProperties;
    }

    public static void setValue(String key, String value) {
        properties.setProperty(key, value);
    }

    public static Map<String, String> getPropertiesByPrefix(String prefix) {
        if (StringUtils.isEmpty(prefix)) {
            return null;
        }
        Set<Object> keys = properties.keySet();
        if (keys.isEmpty()) {
            return null;
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        keys.forEach(k -> {
            if (k.toString().contains(prefix)) {
                propertiesMap.put(k.toString().replaceFirst(prefix + ".", ""), properties.getProperty((String)k));
            }
        });
        return propertiesMap;
    }

    static {
        PropertyUtils.loadPropertyFile("/common.properties");
    }
}

