/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.register;

import org.apache.dolphinscheduler.spi.DolphinSchedulerPlugin;
import org.apache.dolphinscheduler.spi.classloader.ThreadContextClassLoader;
import org.apache.dolphinscheduler.spi.plugin.AbstractDolphinPluginManager;
import org.apache.dolphinscheduler.spi.register.Registry;
import org.apache.dolphinscheduler.spi.register.RegistryException;
import org.apache.dolphinscheduler.spi.register.RegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryPluginManager
extends AbstractDolphinPluginManager {
    private static final Logger logger = LoggerFactory.getLogger(RegistryPluginManager.class);
    private RegistryFactory registryFactory;
    public static Registry registry;
    private String registerPluginName;

    public RegistryPluginManager(String registerPluginName) {
        this.registerPluginName = registerPluginName;
    }

    @Override
    public void installPlugin(DolphinSchedulerPlugin dolphinSchedulerPlugin) {
        for (RegistryFactory registryFactory : dolphinSchedulerPlugin.getRegisterFactorys()) {
            logger.info("Registering Registry Plugin '{}'", (Object)registryFactory.getName());
            if (!this.registerPluginName.equals(registryFactory.getName())) continue;
            this.registryFactory = registryFactory;
            this.loadRegistry();
            return;
        }
        if (null == registry) {
            throw new RegistryException(String.format("not found %s registry plugin ", this.registerPluginName));
        }
    }

    private void loadRegistry() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.registryFactory.getClass().getClassLoader());){
            registry = this.registryFactory.create();
        }
    }

    public Registry getRegistry() {
        if (null == registry) {
            throw new RegistryException("not install registry");
        }
        return registry;
    }
}

