/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.plugin;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import java.util.Objects;

public class DolphinPluginManagerConfig {
    private File installedPluginsDir;
    private List<String> plugins;
    private String mavenLocalRepository = System.getProperty("user.home") + "/.m2/repository";
    private List<String> mavenRemoteRepository = ImmutableList.of((Object)"http://repo1.maven.org/maven2/");

    File getInstalledPluginsDir() {
        return this.installedPluginsDir;
    }

    public void setInstalledPluginsDir(String pluginDir) {
        Objects.requireNonNull(pluginDir, "pluginDir can not be null");
        File pluginDirFile = new File(pluginDir);
        if (!pluginDirFile.exists()) {
            throw new IllegalArgumentException(String.format("plugin dir not exists ! %s", pluginDirFile.getPath()));
        }
        this.installedPluginsDir = pluginDirFile;
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    public DolphinPluginManagerConfig setPlugins(List<String> plugins) {
        this.plugins = plugins;
        return this;
    }

    public DolphinPluginManagerConfig setPlugins(String plugins) {
        this.plugins = plugins == null ? null : ImmutableList.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)plugins));
        return this;
    }

    String getMavenLocalRepository() {
        return this.mavenLocalRepository;
    }

    public void setMavenLocalRepository(String mavenLocalRepository) {
        this.mavenLocalRepository = mavenLocalRepository;
    }

    List<String> getMavenRemoteRepository() {
        return this.mavenRemoteRepository;
    }

    public DolphinPluginManagerConfig setMavenRemoteRepository(List<String> mavenRemoteRepository) {
        this.mavenRemoteRepository = mavenRemoteRepository;
        return this;
    }

    public DolphinPluginManagerConfig setMavenRemoteRepository(String mavenRemoteRepository) {
        this.mavenRemoteRepository = ImmutableList.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)mavenRemoteRepository));
        return this;
    }
}

